/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.Strings;
import org.codelibs.elasticsearch.common.geo.GeoPoint;
import org.codelibs.elasticsearch.common.geo.GeoUtils;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.query.AbstractQueryBuilder;
import org.codelibs.elasticsearch.index.query.GeoValidationMethod;
import org.codelibs.elasticsearch.index.query.QueryParseContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;

public class GeoPolygonQueryBuilder
extends AbstractQueryBuilder<GeoPolygonQueryBuilder> {
    public static final String NAME = "geo_polygon";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField COERCE_FIELD = new ParseField("coerce", "normalize").withAllDeprecated("validation_method");
    private static final ParseField IGNORE_MALFORMED_FIELD = new ParseField("ignore_malformed", new String[0]).withAllDeprecated("validation_method");
    private static final ParseField VALIDATION_METHOD = new ParseField("validation_method", new String[0]);
    private static final ParseField POINTS_FIELD = new ParseField("points", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private final List<GeoPoint> shell;
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private boolean ignoreUnmapped = false;

    public GeoPolygonQueryBuilder(String fieldName, List<GeoPoint> points) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (points == null || points.isEmpty()) {
            throw new IllegalArgumentException("polygon must not be null or empty");
        }
        GeoPoint start = points.get(0);
        if (start.equals(points.get(points.size() - 1)) ? points.size() < 4 : points.size() < 3) {
            throw new IllegalArgumentException("too few points defined for geo_polygon query");
        }
        this.fieldName = fieldName;
        this.shell = new ArrayList<GeoPoint>(points);
        if (!this.shell.get(this.shell.size() - 1).equals(this.shell.get(0))) {
            this.shell.add(this.shell.get(0));
        }
    }

    public GeoPolygonQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        int size = in.readVInt();
        this.shell = new ArrayList<GeoPoint>(size);
        for (int i = 0; i < size; ++i) {
            this.shell.add(in.readGeoPoint());
        }
        this.validationMethod = GeoValidationMethod.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeVInt(this.shell.size());
        for (GeoPoint point : this.shell) {
            out.writeGeoPoint(point);
        }
        this.validationMethod.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public List<GeoPoint> points() {
        return this.shell;
    }

    public GeoPolygonQueryBuilder setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
        return this;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoPolygonQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.startArray(POINTS_FIELD.getPreferredName());
        for (GeoPoint point : this.shell) {
            builder.startArray().value(point.lon()).value(point.lat()).endArray();
        }
        builder.endArray();
        builder.endObject();
        builder.field(VALIDATION_METHOD.getPreferredName(), this.validationMethod);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<GeoPolygonQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        ArrayList<GeoPoint> shell = null;
        Float boost = null;
        boolean coerce = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        boolean ignoreMalformed = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        GeoValidationMethod validationMethod = null;
        String queryName = null;
        String currentFieldName = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (POINTS_FIELD.match(currentFieldName)) {
                            shell = new ArrayList<GeoPoint>();
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                shell.add(GeoUtils.parseGeoPoint(parser));
                            }
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[geo_polygon] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[geo_polygon] query does not support token type [" + token.name() + "] under [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (token.isValue()) {
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = Float.valueOf(parser.floatValue());
                    continue;
                }
                if (COERCE_FIELD.match(currentFieldName)) {
                    coerce = parser.booleanValue();
                    if (!coerce) continue;
                    ignoreMalformed = true;
                    continue;
                }
                if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                    ignoreUnmapped = parser.booleanValue();
                    continue;
                }
                if (IGNORE_MALFORMED_FIELD.match(currentFieldName)) {
                    ignoreMalformed = parser.booleanValue();
                    continue;
                }
                if (VALIDATION_METHOD.match(currentFieldName)) {
                    validationMethod = GeoValidationMethod.fromString(parser.text());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[geo_polygon] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[geo_polygon] unexpected token type [" + token.name() + "]", new Object[0]);
        }
        GeoPolygonQueryBuilder builder = new GeoPolygonQueryBuilder(fieldName, shell);
        if (validationMethod != null) {
            builder.setValidationMethod(validationMethod);
        } else {
            builder.setValidationMethod(GeoValidationMethod.infer(coerce, ignoreMalformed));
        }
        if (queryName != null) {
            builder.queryName(queryName);
        }
        if (boost != null) {
            builder.boost(boost.floatValue());
        }
        builder.ignoreUnmapped(ignoreUnmapped);
        return Optional.of(builder);
    }

    @Override
    protected boolean doEquals(GeoPolygonQueryBuilder other) {
        return Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.shell, other.shell) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.validationMethod, this.fieldName, this.shell, this.ignoreUnmapped);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

