/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.mapper;

import java.io.IOException;
import org.codelibs.elasticsearch.Version;
import org.codelibs.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.codelibs.elasticsearch.common.joda.Joda;
import org.codelibs.elasticsearch.common.lucene.Lucene;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.mapper.EnabledAttributeMapper;
import org.codelibs.elasticsearch.index.mapper.LegacyDateFieldMapper;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;
import org.codelibs.elasticsearch.index.mapper.Mapper;
import org.codelibs.elasticsearch.index.mapper.MetadataFieldMapper;

public class TimestampFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_timestamp";
    public static final String CONTENT_TYPE = "_timestamp";
    public static final String DEFAULT_DATE_TIME_FORMAT = "epoch_millis||strictDateOptionalTime";
    private final EnabledAttributeMapper enabledState;
    private final String defaultTimestamp;
    private final Boolean ignoreMissing;

    private TimestampFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing != null ? existing : Defaults.FIELD_TYPE, (MappedFieldType)Defaults.FIELD_TYPE, Defaults.ENABLED, "now", null, indexSettings);
    }

    private TimestampFieldMapper(MappedFieldType fieldType, MappedFieldType defaultFieldType, EnabledAttributeMapper enabledState, String defaultTimestamp, Boolean ignoreMissing, Settings indexSettings) {
        super("_timestamp", fieldType, defaultFieldType, indexSettings);
        if (enabledState.enabled && Version.indexCreated(indexSettings).onOrAfter(Version.V_5_0_0_alpha4)) {
            throw new IllegalArgumentException("[_timestamp] is removed in 5.0. As a replacement, you can use an ingest pipeline to add a field with the current timestamp to your documents.");
        }
        this.enabledState = enabledState;
        this.defaultTimestamp = defaultTimestamp;
        this.ignoreMissing = ignoreMissing;
    }

    @Override
    public TimestampFieldType fieldType() {
        return (TimestampFieldType)super.fieldType();
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public String defaultTimestamp() {
        return this.defaultTimestamp;
    }

    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    protected String contentType() {
        return "_timestamp";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabledState == Defaults.ENABLED && this.fieldType().dateTimeFormatter().format().equals(Defaults.DATE_TIME_FORMATTER.format()) && "now".equals(this.defaultTimestamp)) {
            return builder;
        }
        builder.startObject("_timestamp");
        if (includeDefaults || this.enabledState != Defaults.ENABLED) {
            builder.field("enabled", this.enabledState.enabled);
        }
        String defaultDateFormat = Defaults.DATE_TIME_FORMATTER.format();
        if (includeDefaults || !this.fieldType().dateTimeFormatter().format().equals(defaultDateFormat)) {
            builder.field("format", this.fieldType().dateTimeFormatter().format());
        }
        if (includeDefaults || !"now".equals(this.defaultTimestamp)) {
            builder.field("default", this.defaultTimestamp);
        }
        if (includeDefaults || this.ignoreMissing != null) {
            builder.field("ignore_missing", this.ignoreMissing);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        throw new UnsupportedOperationException();
    }

    public static final class TimestampFieldType
    extends LegacyDateFieldMapper.DateFieldType {
        public TimestampFieldType() {
        }

        protected TimestampFieldType(TimestampFieldType ref) {
            super(ref);
        }

        @Override
        public TimestampFieldType clone() {
            return new TimestampFieldType(this);
        }

        @Override
        public Object valueForDisplay(Object value) {
            return value;
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, TimestampFieldMapper> {
        private EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;
        private String defaultTimestamp = "now";
        private Boolean ignoreMissing = null;

        public Builder(MappedFieldType existing) {
            super("_timestamp", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
        }

        @Override
        public LegacyDateFieldMapper.DateFieldType fieldType() {
            return (LegacyDateFieldMapper.DateFieldType)this.fieldType;
        }

        public Builder enabled(EnabledAttributeMapper enabledState) {
            this.enabledState = enabledState;
            return (Builder)this.builder;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.fieldType().setDateTimeFormatter(dateTimeFormatter);
            return this;
        }

        public Builder defaultTimestamp(String defaultTimestamp) {
            this.defaultTimestamp = defaultTimestamp;
            return (Builder)this.builder;
        }

        public Builder ignoreMissing(boolean ignoreMissing) {
            this.ignoreMissing = ignoreMissing;
            return (Builder)this.builder;
        }

        @Override
        public Builder store(boolean store) {
            return (Builder)super.store(store);
        }

        @Override
        public TimestampFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new TimestampFieldMapper(this.fieldType, this.defaultFieldType, this.enabledState, this.defaultTimestamp, this.ignoreMissing, context.indexSettings());
        }
    }

    public static class Defaults
    extends LegacyDateFieldMapper.Defaults {
        public static final String NAME = "_timestamp";
        public static final TimestampFieldType FIELD_TYPE = new TimestampFieldType();
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("epoch_millis||strictDateOptionalTime");
        public static final EnabledAttributeMapper ENABLED;
        public static final String DEFAULT_TIMESTAMP = "now";

        static {
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setNumericPrecisionStep(16);
            FIELD_TYPE.setName("_timestamp");
            FIELD_TYPE.setDateTimeFormatter(DATE_TIME_FORMATTER);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.freeze();
            ENABLED = EnabledAttributeMapper.UNSET_DISABLED;
        }
    }
}

