/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.action.fieldstats.FieldStats;
import org.codelibs.elasticsearch.common.Explicit;
import org.codelibs.elasticsearch.common.settings.Setting;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.fielddata.IndexFieldData;
import org.codelibs.elasticsearch.index.mapper.FieldMapper;
import org.codelibs.elasticsearch.index.mapper.LegacyNumberFieldMapper;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;
import org.codelibs.elasticsearch.index.mapper.Mapper;
import org.codelibs.elasticsearch.index.mapper.NumberFieldMapper;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.joda.time.DateTimeZone;

public class ScaledFloatFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "scaled_float";
    private static final Setting<Boolean> COERCE_SETTING = NumberFieldMapper.COERCE_SETTING;
    private Boolean includeInAll;
    private Explicit<Boolean> ignoreMalformed;
    private Explicit<Boolean> coerce;

    private ScaledFloatFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        double scalingFactor = this.fieldType().getScalingFactor();
        if (!Double.isFinite(scalingFactor) || scalingFactor <= 0.0) {
            throw new IllegalArgumentException("[scaling_factor] must be a positive number, got [" + scalingFactor + "]");
        }
        this.ignoreMalformed = ignoreMalformed;
        this.coerce = coerce;
        this.includeInAll = includeInAll;
    }

    @Override
    public ScaledFloatFieldType fieldType() {
        return (ScaledFloatFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected ScaledFloatFieldMapper clone() {
        return (ScaledFloatFieldMapper)super.clone();
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        ScaledFloatFieldMapper other = (ScaledFloatFieldMapper)mergeWith;
        this.includeInAll = other.includeInAll;
        if (other.ignoreMalformed.explicit()) {
            this.ignoreMalformed = other.ignoreMalformed;
        }
        if (other.coerce.explicit()) {
            this.coerce = other.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        builder.field("scaling_factor", this.fieldType().getScalingFactor());
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static final class ScaledFloatFieldType
    extends MappedFieldType {
        private double scalingFactor;

        public ScaledFloatFieldType() {
            this.setTokenized(false);
            this.setHasDocValues(true);
            this.setOmitNorms(true);
        }

        ScaledFloatFieldType(ScaledFloatFieldType other) {
            super(other);
            this.scalingFactor = other.scalingFactor;
        }

        public double getScalingFactor() {
            return this.scalingFactor;
        }

        public void setScalingFactor(double scalingFactor) {
            this.checkIfFrozen();
            this.scalingFactor = scalingFactor;
        }

        @Override
        public MappedFieldType clone() {
            return new ScaledFloatFieldType(this);
        }

        @Override
        public String typeName() {
            return ScaledFloatFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
            super.checkCompatibility(other, conflicts, strict);
            if (this.scalingFactor != ((ScaledFloatFieldType)other).getScalingFactor()) {
                conflicts.add("mapper [" + this.name() + "] has different [scaling_factor] values");
            }
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexed();
            double queryValue = NumberFieldMapper.NumberType.DOUBLE.parse(value, false).doubleValue();
            long scaledValue = Math.round(queryValue * this.scalingFactor);
            Query query = NumberFieldMapper.NumberType.LONG.termQuery(this.name(), scaledValue);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query termsQuery(List values, QueryShardContext context) {
            this.failIfNotIndexed();
            ArrayList<Long> scaledValues = new ArrayList<Long>(values.size());
            for (Object value : values) {
                double queryValue = NumberFieldMapper.NumberType.DOUBLE.parse(value, false).doubleValue();
                long scaledValue = Math.round(queryValue * this.scalingFactor);
                scaledValues.add(scaledValue);
            }
            Query query = NumberFieldMapper.NumberType.LONG.termsQuery(this.name(), Collections.unmodifiableList(scaledValues));
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            Long lo = null;
            if (lowerTerm != null) {
                double dValue = NumberFieldMapper.NumberType.DOUBLE.parse(lowerTerm, false).doubleValue();
                if (!includeLower) {
                    dValue = Math.nextUp(dValue);
                }
                lo = Math.round(Math.ceil(dValue * this.scalingFactor));
            }
            Long hi = null;
            if (upperTerm != null) {
                double dValue = NumberFieldMapper.NumberType.DOUBLE.parse(upperTerm, false).doubleValue();
                if (!includeUpper) {
                    dValue = Math.nextDown(dValue);
                }
                hi = Math.round(Math.floor(dValue * this.scalingFactor));
            }
            Query query = NumberFieldMapper.NumberType.LONG.rangeQuery(this.name(), lo, hi, true, true);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public FieldStats<?> stats(IndexReader reader) throws IOException {
            FieldStats.Long stats = (FieldStats.Long)NumberFieldMapper.NumberType.LONG.stats(reader, this.name(), this.isSearchable(), this.isAggregatable());
            if (stats == null) {
                return null;
            }
            return new FieldStats.Double(stats.getMaxDoc(), stats.getDocCount(), stats.getSumDocFreq(), stats.getSumTotalTermFreq(), stats.isSearchable(), stats.isAggregatable(), stats.getMinValue() == null ? null : Double.valueOf((double)((Long)stats.getMinValue()).longValue() / this.scalingFactor), stats.getMaxValue() == null ? null : Double.valueOf((double)((Long)stats.getMaxValue()).longValue() / this.scalingFactor));
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return (double)((Number)value).longValue() / this.scalingFactor;
        }

        @Override
        public DocValueFormat docValueFormat(String format, DateTimeZone timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            return this.scalingFactor == ((ScaledFloatFieldType)((Object)o)).scalingFactor;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Double.hashCode(this.scalingFactor);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, ScaledFloatFieldMapper> {
        private boolean scalingFactorSet = false;
        private Boolean ignoreMalformed;
        private Boolean coerce;

        public Builder(String name) {
            super(name, new ScaledFloatFieldType(), new ScaledFloatFieldType());
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return LegacyNumberFieldMapper.Defaults.IGNORE_MALFORMED;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        public Builder scalingFactor(double scalingFactor) {
            ((ScaledFloatFieldType)this.fieldType).setScalingFactor(scalingFactor);
            this.scalingFactorSet = true;
            return this;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>((Boolean)COERCE_SETTING.get(context.indexSettings()), false);
            }
            return LegacyNumberFieldMapper.Defaults.COERCE;
        }

        @Override
        public ScaledFloatFieldMapper build(Mapper.BuilderContext context) {
            if (!this.scalingFactorSet) {
                throw new IllegalArgumentException("Field [" + this.name + "] misses required parameter [scaling_factor]");
            }
            this.setupFieldType(context);
            return new ScaledFloatFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

