/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.HalfFloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.codelibs.elasticsearch.action.fieldstats.FieldStats;
import org.codelibs.elasticsearch.common.Explicit;
import org.codelibs.elasticsearch.common.lucene.search.Queries;
import org.codelibs.elasticsearch.common.settings.Setting;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.index.fielddata.IndexFieldData;
import org.codelibs.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.codelibs.elasticsearch.index.mapper.FieldMapper;
import org.codelibs.elasticsearch.index.mapper.LegacyNumberFieldMapper;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;
import org.codelibs.elasticsearch.index.mapper.Mapper;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.joda.time.DateTimeZone;

public class NumberFieldMapper
extends FieldMapper {
    static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private Boolean includeInAll;
    private Explicit<Boolean> ignoreMalformed;
    private Explicit<Boolean> coerce;

    private NumberFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.coerce = coerce;
        this.includeInAll = includeInAll;
    }

    @Override
    public NumberFieldType fieldType() {
        return (NumberFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected NumberFieldMapper clone() {
        return (NumberFieldMapper)super.clone();
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        NumberFieldMapper other = (NumberFieldMapper)mergeWith;
        this.includeInAll = other.includeInAll;
        if (other.ignoreMalformed.explicit()) {
            this.ignoreMalformed = other.ignoreMalformed;
        }
        if (other.coerce.explicit()) {
            this.coerce = other.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static final class NumberFieldType
    extends MappedFieldType {
        NumberType type;

        public NumberFieldType(NumberType type) {
            this.type = Objects.requireNonNull(type);
            this.setTokenized(false);
            this.setHasDocValues(true);
            this.setOmitNorms(true);
        }

        NumberFieldType(NumberFieldType other) {
            super(other);
            this.type = other.type;
        }

        @Override
        public MappedFieldType clone() {
            return new NumberFieldType(this);
        }

        @Override
        public String typeName() {
            return this.type.name;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.termQuery(this.name(), value);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query termsQuery(List values, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.termsQuery(this.name(), values);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            Query query = this.type.rangeQuery(this.name(), lowerTerm, upperTerm, includeLower, includeUpper);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public FieldStats stats(IndexReader reader) throws IOException {
            return this.type.stats(reader, this.name(), this.isSearchable(), this.isAggregatable());
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return this.type.valueForSearch((Number)value);
        }

        @Override
        public DocValueFormat docValueFormat(String format, DateTimeZone timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }
    }

    public static enum NumberType {
        HALF_FLOAT("half_float", IndexNumericFieldData.NumericType.HALF_FLOAT){

            @Override
            Float parse(Object value, boolean coerce) {
                return (Float)FLOAT.parse(value, false);
            }

            @Override
            Float parse(XContentParser parser, boolean coerce) throws IOException {
                return Float.valueOf(parser.floatValue(coerce));
            }

            @Override
            Query termQuery(String field, Object value) {
                float v = this.parse(value, false).floatValue();
                return HalfFloatPoint.newExactQuery((String)field, (float)v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                float[] v = new float[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                }
                return HalfFloatPoint.newSetQuery((String)field, (float[])v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (includeLower) {
                        l = HalfFloatPoint.nextDown((float)l);
                    }
                    l = HalfFloatPoint.nextUp((float)l);
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (includeUpper) {
                        u = HalfFloatPoint.nextUp((float)u);
                    }
                    u = HalfFloatPoint.nextDown((float)u);
                }
                return HalfFloatPoint.newRangeQuery((String)field, (float)l, (float)u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new HalfFloatPoint(name, new float[]{value.floatValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)HalfFloatPoint.halfFloatToSortableShort((float)value.floatValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            FieldStats.Double stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos((IndexReader)reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size((IndexReader)reader, (String)fieldName);
                if (size == 0L) {
                    return new FieldStats.Double(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount((IndexReader)reader, (String)fieldName);
                byte[] min = PointValues.getMinPackedValue((IndexReader)reader, (String)fieldName);
                byte[] max = PointValues.getMaxPackedValue((IndexReader)reader, (String)fieldName);
                return new FieldStats.Double(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, HalfFloatPoint.decodeDimension((byte[])min, (int)0), HalfFloatPoint.decodeDimension((byte[])max, (int)0));
            }
        }
        ,
        FLOAT("float", IndexNumericFieldData.NumericType.FLOAT){

            @Override
            Float parse(Object value, boolean coerce) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                return Float.valueOf(Float.parseFloat(value.toString()));
            }

            @Override
            Float parse(XContentParser parser, boolean coerce) throws IOException {
                return Float.valueOf(parser.floatValue(coerce));
            }

            @Override
            Query termQuery(String field, Object value) {
                float v = this.parse(value, false).floatValue();
                return FloatPoint.newExactQuery((String)field, (float)v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                float[] v = new float[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                }
                return FloatPoint.newSetQuery((String)field, (float[])v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (!includeLower) {
                        l = FloatPoint.nextUp((float)l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (!includeUpper) {
                        u = FloatPoint.nextDown((float)u);
                    }
                }
                return FloatPoint.newRangeQuery((String)field, (float)l, (float)u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new FloatPoint(name, new float[]{value.floatValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)NumericUtils.floatToSortableInt((float)value.floatValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            FieldStats.Double stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos((IndexReader)reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size((IndexReader)reader, (String)fieldName);
                if (size == 0L) {
                    return new FieldStats.Double(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount((IndexReader)reader, (String)fieldName);
                byte[] min = PointValues.getMinPackedValue((IndexReader)reader, (String)fieldName);
                byte[] max = PointValues.getMaxPackedValue((IndexReader)reader, (String)fieldName);
                return new FieldStats.Double(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, FloatPoint.decodeDimension((byte[])min, (int)0), FloatPoint.decodeDimension((byte[])max, (int)0));
            }
        }
        ,
        DOUBLE("double", IndexNumericFieldData.NumericType.DOUBLE){

            @Override
            Double parse(Object value, boolean coerce) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                return Double.parseDouble(value.toString());
            }

            @Override
            Double parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.doubleValue(coerce);
            }

            @Override
            Query termQuery(String field, Object value) {
                double v = this.parse(value, false);
                return DoublePoint.newExactQuery((String)field, (double)v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                double[] v = new double[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false);
                }
                return DoublePoint.newSetQuery((String)field, (double[])v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
                double l = Double.NEGATIVE_INFINITY;
                double u = Double.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false);
                    if (!includeLower) {
                        l = DoublePoint.nextUp((double)l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false);
                    if (!includeUpper) {
                        u = DoublePoint.nextDown((double)u);
                    }
                }
                return DoublePoint.newRangeQuery((String)field, (double)l, (double)u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new DoublePoint(name, new double[]{value.doubleValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong((double)value.doubleValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.doubleValue()));
                }
                return fields;
            }

            FieldStats.Double stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos((IndexReader)reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size((IndexReader)reader, (String)fieldName);
                if (size == 0L) {
                    return new FieldStats.Double(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount((IndexReader)reader, (String)fieldName);
                byte[] min = PointValues.getMinPackedValue((IndexReader)reader, (String)fieldName);
                byte[] max = PointValues.getMaxPackedValue((IndexReader)reader, (String)fieldName);
                return new FieldStats.Double(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, DoublePoint.decodeDimension((byte[])min, (int)0), DoublePoint.decodeDimension((byte[])max, (int)0));
            }
        }
        ,
        BYTE("byte", IndexNumericFieldData.NumericType.BYTE){

            @Override
            Byte parse(Object value, boolean coerce) {
                if (value instanceof Number) {
                    double doubleValue = ((Number)value).doubleValue();
                    if (doubleValue < -128.0 || doubleValue > 127.0) {
                        throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                    }
                    if (!coerce && doubleValue % 1.0 != 0.0) {
                        throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                    }
                    return ((Number)value).byteValue();
                }
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                return Byte.parseByte(value.toString());
            }

            @Override
            Short parse(XContentParser parser, boolean coerce) throws IOException {
                int value = parser.intValue(coerce);
                if (value < -128 || value > 127) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                return (short)value;
            }

            @Override
            Query termQuery(String field, Object value) {
                return INTEGER.termQuery(field, value);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            FieldStats.Long stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                return (FieldStats.Long)INTEGER.stats(reader, fieldName, isSearchable, isAggregatable);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.byteValue();
            }
        }
        ,
        SHORT("short", IndexNumericFieldData.NumericType.SHORT){

            @Override
            Short parse(Object value, boolean coerce) {
                if (value instanceof Number) {
                    double doubleValue = ((Number)value).doubleValue();
                    if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                        throw new IllegalArgumentException("Value [" + value + "] is out of range for a short");
                    }
                    if (!coerce && doubleValue % 1.0 != 0.0) {
                        throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                    }
                    return ((Number)value).shortValue();
                }
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                return Short.parseShort(value.toString());
            }

            @Override
            Short parse(XContentParser parser, boolean coerce) throws IOException {
                int value = parser.intValue(coerce);
                if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a short");
                }
                return (short)value;
            }

            @Override
            Query termQuery(String field, Object value) {
                return INTEGER.termQuery(field, value);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            FieldStats.Long stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                return (FieldStats.Long)INTEGER.stats(reader, fieldName, isSearchable, isAggregatable);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.shortValue();
            }
        }
        ,
        INTEGER("integer", IndexNumericFieldData.NumericType.INT){

            @Override
            Integer parse(Object value, boolean coerce) {
                if (value instanceof Number) {
                    double doubleValue = ((Number)value).doubleValue();
                    if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                        throw new IllegalArgumentException("Value [" + value + "] is out of range for an integer");
                    }
                    if (!coerce && doubleValue % 1.0 != 0.0) {
                        throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                    }
                    return ((Number)value).intValue();
                }
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                return Integer.parseInt(value.toString());
            }

            @Override
            Integer parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.intValue(coerce);
            }

            @Override
            Query termQuery(String field, Object value) {
                if (this.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                int v = this.parse(value, true);
                return IntPoint.newExactQuery((String)field, (int)v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                int[] v = new int[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (this.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return IntPoint.newSetQuery((String)field, (int[])v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
                int l = Integer.MIN_VALUE;
                int u = Integer.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = this.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && this.signum(lowerTerm) > 0.0) {
                        if (l == Integer.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = this.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && this.signum(upperTerm) < 0.0) {
                        if (u == Integer.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                return IntPoint.newRangeQuery((String)field, (int)l, (int)u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new IntPoint(name, new int[]{value.intValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)value.intValue()));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.intValue()));
                }
                return fields;
            }

            FieldStats.Long stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos((IndexReader)reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size((IndexReader)reader, (String)fieldName);
                if (size == 0L) {
                    return new FieldStats.Long(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount((IndexReader)reader, (String)fieldName);
                byte[] min = PointValues.getMinPackedValue((IndexReader)reader, (String)fieldName);
                byte[] max = PointValues.getMaxPackedValue((IndexReader)reader, (String)fieldName);
                return new FieldStats.Long(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, IntPoint.decodeDimension((byte[])min, (int)0), IntPoint.decodeDimension((byte[])max, (int)0));
            }
        }
        ,
        LONG("long", IndexNumericFieldData.NumericType.LONG){

            @Override
            Long parse(Object value, boolean coerce) {
                if (value instanceof Number) {
                    double doubleValue = ((Number)value).doubleValue();
                    if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                        throw new IllegalArgumentException("Value [" + value + "] is out of range for a long");
                    }
                    if (!coerce && doubleValue % 1.0 != 0.0) {
                        throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                    }
                    return ((Number)value).longValue();
                }
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                return Long.parseLong(value.toString());
            }

            @Override
            Long parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.longValue(coerce);
            }

            @Override
            Query termQuery(String field, Object value) {
                if (this.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                long v = this.parse(value, true);
                return LongPoint.newExactQuery((String)field, (long)v);
            }

            @Override
            Query termsQuery(String field, List<Object> values) {
                long[] v = new long[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (this.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return LongPoint.newSetQuery((String)field, (long[])v);
            }

            @Override
            Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
                long l = Long.MIN_VALUE;
                long u = Long.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = this.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && this.signum(lowerTerm) > 0.0) {
                        if (l == Long.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = this.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && this.signum(upperTerm) < 0.0) {
                        if (u == Long.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                return LongPoint.newRangeQuery((String)field, (long)l, (long)u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new LongPoint(name, new long[]{value.longValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, value.longValue()));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.longValue()));
                }
                return fields;
            }

            FieldStats.Long stats(IndexReader reader, String fieldName, boolean isSearchable, boolean isAggregatable) throws IOException {
                FieldInfo fi = MultiFields.getMergedFieldInfos((IndexReader)reader).fieldInfo(fieldName);
                if (fi == null) {
                    return null;
                }
                long size = PointValues.size((IndexReader)reader, (String)fieldName);
                if (size == 0L) {
                    return new FieldStats.Long(reader.maxDoc(), 0L, -1L, -1L, isSearchable, isAggregatable);
                }
                int docCount = PointValues.getDocCount((IndexReader)reader, (String)fieldName);
                byte[] min = PointValues.getMinPackedValue((IndexReader)reader, (String)fieldName);
                byte[] max = PointValues.getMaxPackedValue((IndexReader)reader, (String)fieldName);
                return new FieldStats.Long(reader.maxDoc(), docCount, -1L, size, isSearchable, isAggregatable, LongPoint.decodeDimension((byte[])min, (int)0), LongPoint.decodeDimension((byte[])max, (int)0));
            }
        };

        private final String name;
        private final IndexNumericFieldData.NumericType numericType;

        private NumberType(String name, IndexNumericFieldData.NumericType numericType) {
            this.name = name;
            this.numericType = numericType;
        }

        public final String typeName() {
            return this.name;
        }

        final IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        abstract Query termQuery(String var1, Object var2);

        abstract Query termsQuery(String var1, List<Object> var2);

        abstract Query rangeQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

        abstract Number parse(XContentParser var1, boolean var2) throws IOException;

        abstract Number parse(Object var1, boolean var2);

        public abstract List<Field> createFields(String var1, Number var2, boolean var3, boolean var4, boolean var5);

        abstract FieldStats<? extends Number> stats(IndexReader var1, String var2, boolean var3, boolean var4) throws IOException;

        Number valueForSearch(Number value) {
            return value;
        }

        boolean hasDecimalPart(Object number) {
            if (number instanceof Number) {
                double doubleValue = ((Number)number).doubleValue();
                return doubleValue % 1.0 != 0.0;
            }
            if (number instanceof BytesRef) {
                number = ((BytesRef)number).utf8ToString();
            }
            if (number instanceof String) {
                return Double.parseDouble((String)number) % 1.0 != 0.0;
            }
            return false;
        }

        double signum(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                return Math.signum(doubleValue);
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Math.signum(Double.parseDouble(value.toString()));
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        final NumberType type;

        public TypeParser(NumberType type) {
            this.type = type;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, NumberFieldMapper> {
        private Boolean ignoreMalformed;
        private Boolean coerce;

        public Builder(String name, NumberType type) {
            super(name, new NumberFieldType(type), new NumberFieldType(type));
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return LegacyNumberFieldMapper.Defaults.IGNORE_MALFORMED;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(COERCE_SETTING.get(context.indexSettings()), false);
            }
            return LegacyNumberFieldMapper.Defaults.COERCE;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
        }

        @Override
        public NumberFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new NumberFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

