/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.mapper;

import java.util.Map;
import java.util.Objects;
import org.codelibs.elasticsearch.Version;
import org.codelibs.elasticsearch.common.Nullable;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.index.mapper.ContentPath;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;

public abstract class Mapper
implements ToXContent,
Iterable<Mapper> {
    private final String simpleName;

    public Mapper(String simpleName) {
        Objects.requireNonNull(simpleName);
        this.simpleName = simpleName;
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String name();

    public abstract Mapper merge(Mapper var1, boolean var2);

    public abstract Mapper updateFieldType(Map<String, MappedFieldType> var1);

    public static interface TypeParser {
    }

    public static abstract class Builder<T extends Builder, Y extends Mapper> {
        public String name;
        protected T builder;

        protected Builder(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract Y build(BuilderContext var1);
    }

    public static class BuilderContext {
        private final Settings indexSettings;
        private final ContentPath contentPath;

        public BuilderContext(Settings indexSettings, ContentPath contentPath) {
            this.contentPath = contentPath;
            this.indexSettings = indexSettings;
        }

        public ContentPath path() {
            return this.contentPath;
        }

        @Nullable
        public Settings indexSettings() {
            return this.indexSettings;
        }

        @Nullable
        public Version indexCreatedVersion() {
            if (this.indexSettings == null) {
                return null;
            }
            return Version.indexCreated(this.indexSettings);
        }
    }
}

