/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.action.fieldstats.FieldStats;
import org.codelibs.elasticsearch.common.Nullable;
import org.codelibs.elasticsearch.common.joda.DateMathParser;
import org.codelibs.elasticsearch.common.unit.Fuzziness;
import org.codelibs.elasticsearch.index.analysis.NamedAnalyzer;
import org.codelibs.elasticsearch.index.fielddata.IndexFieldData;
import org.codelibs.elasticsearch.index.query.QueryRewriteContext;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.index.query.QueryShardException;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.joda.time.DateTimeZone;

public abstract class MappedFieldType
extends FieldType {
    private String name;
    private float boost;
    private boolean docValues;
    private NamedAnalyzer indexAnalyzer;
    private NamedAnalyzer searchAnalyzer;
    private NamedAnalyzer searchQuoteAnalyzer;
    private Object nullValue;
    private String nullValueAsString;
    private boolean eagerGlobalOrdinals;

    protected MappedFieldType(MappedFieldType ref) {
        super((FieldType)ref);
        this.name = ref.name();
        this.boost = ref.boost();
        this.docValues = ref.hasDocValues();
        this.indexAnalyzer = ref.indexAnalyzer();
        this.searchAnalyzer = ref.searchAnalyzer();
        this.searchQuoteAnalyzer = ref.searchQuoteAnalyzer();
        this.nullValue = ref.nullValue();
        this.nullValueAsString = ref.nullValueAsString();
        this.eagerGlobalOrdinals = ref.eagerGlobalOrdinals;
    }

    public MappedFieldType() {
        this.setTokenized(true);
        this.setStored(false);
        this.setStoreTermVectors(false);
        this.setOmitNorms(false);
        this.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        this.setBoost(1.0f);
    }

    public abstract MappedFieldType clone();

    public IndexFieldData.Builder fielddataBuilder() {
        throw new IllegalArgumentException("Fielddata is not supported on field [" + this.name() + "] of type [" + this.typeName() + "]");
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public abstract String typeName();

    public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
        throw new UnsupportedOperationException();
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.checkIfFrozen();
        this.name = name;
    }

    public float boost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.checkIfFrozen();
        this.boost = boost;
    }

    public boolean hasDocValues() {
        return this.docValues;
    }

    public void setHasDocValues(boolean hasDocValues) {
        this.checkIfFrozen();
        this.docValues = hasDocValues;
    }

    public NamedAnalyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public void setIndexAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.indexAnalyzer = analyzer;
    }

    public NamedAnalyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public void setSearchAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.searchAnalyzer = analyzer;
    }

    public NamedAnalyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer == null ? this.searchAnalyzer : this.searchQuoteAnalyzer;
    }

    public void setSearchQuoteAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.searchQuoteAnalyzer = analyzer;
    }

    public Object nullValue() {
        return this.nullValue;
    }

    public String nullValueAsString() {
        return this.nullValueAsString;
    }

    public void setNullValue(Object nullValue) {
        this.checkIfFrozen();
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    public Object valueForDisplay(Object value) {
        return value;
    }

    protected boolean isSearchable() {
        return this.indexOptions() != IndexOptions.NONE;
    }

    protected boolean isAggregatable() {
        try {
            this.fielddataBuilder();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public abstract Query termQuery(Object var1, @Nullable QueryShardContext var2);

    public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Object value : values) {
            builder.add(this.termQuery(value, context), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)builder.build());
    }

    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
        throw new IllegalArgumentException("Field [" + this.name + "] of type [" + this.typeName() + "] does not support range queries");
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        throw new IllegalArgumentException("Can only use fuzzy queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context, "Can only use prefix queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query regexpQuery(String value, int flags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context, "Can only use regexp queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query nullValueQuery() {
        if (this.nullValue == null) {
            return null;
        }
        return new ConstantScoreQuery(this.termQuery(this.nullValue, null));
    }

    public FieldStats stats(IndexReader reader) throws IOException {
        int maxDoc = reader.maxDoc();
        FieldInfo fi = MultiFields.getMergedFieldInfos((IndexReader)reader).fieldInfo(this.name());
        if (fi == null) {
            return null;
        }
        Terms terms = MultiFields.getTerms((IndexReader)reader, (String)this.name());
        if (terms == null) {
            return new FieldStats.Text(maxDoc, 0L, -1L, -1L, this.isSearchable(), this.isAggregatable());
        }
        FieldStats.Text stats = new FieldStats.Text(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), this.isSearchable(), this.isAggregatable(), terms.getMin(), terms.getMax());
        return stats;
    }

    public Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, DateTimeZone timeZone, DateMathParser dateMathParser, QueryRewriteContext context) throws IOException {
        return Relation.INTERSECTS;
    }

    @Nullable
    public Query queryStringTermQuery(Term term) {
        return null;
    }

    protected final void failIfNoDocValues() {
        if (!this.hasDocValues()) {
            throw new IllegalArgumentException("Can't load fielddata on [" + this.name() + "] because fielddata is unsupported on fields of type [" + this.typeName() + "]. Use doc values instead.");
        }
    }

    protected final void failIfNotIndexed() {
        if (this.indexOptions() == IndexOptions.NONE && this.pointDimensionCount() == 0) {
            throw new IllegalArgumentException("Cannot search on field [" + this.name() + "] since it is not indexed.");
        }
    }

    public boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    public void setEagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
        this.checkIfFrozen();
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
    }

    public DocValueFormat docValueFormat(@Nullable String format, DateTimeZone timeZone) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
        }
        if (timeZone != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
        }
        return DocValueFormat.RAW;
    }

    public static Term extractTerm(Query termQuery) {
        throw new UnsupportedOperationException();
    }

    public static enum Relation {
        WITHIN,
        INTERSECTS,
        DISJOINT;

    }
}

