/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.codelibs.elasticsearch.common.lucene.Lucene;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.analysis.NamedAnalyzer;
import org.codelibs.elasticsearch.index.fielddata.IndexFieldData;
import org.codelibs.elasticsearch.index.mapper.FieldMapper;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;
import org.codelibs.elasticsearch.index.mapper.Mapper;
import org.codelibs.elasticsearch.index.mapper.StringFieldType;

public final class KeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "keyword";
    private static final List<String> SUPPORTED_PARAMETERS_FOR_AUTO_DOWNGRADE_TO_STRING = Collections.unmodifiableList(Arrays.asList("type", "index", "store", "doc_values", "omit_norms", "norms", "boost", "fields", "copy_to", "include_in_all", "ignore_above", "index_options", "similarity"));
    private Boolean includeInAll;
    private int ignoreAbove;

    protected KeywordFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, int ignoreAbove, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.ignoreAbove = ignoreAbove;
        this.includeInAll = includeInAll;
    }

    int ignoreAbove() {
        return this.ignoreAbove;
    }

    @Override
    protected KeywordFieldMapper clone() {
        return (KeywordFieldMapper)super.clone();
    }

    @Override
    public KeywordFieldType fieldType() {
        return (KeywordFieldType)super.fieldType();
    }

    Boolean includeInAll() {
        return this.includeInAll;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        this.includeInAll = ((KeywordFieldMapper)mergeWith).includeInAll;
        this.ignoreAbove = ((KeywordFieldMapper)mergeWith).ignoreAbove;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", true);
        }
        if (includeDefaults || this.ignoreAbove != Integer.MAX_VALUE) {
            builder.field("ignore_above", this.ignoreAbove);
        }
        if (this.fieldType().normalizer() != null) {
            builder.field("normalizer", this.fieldType().normalizer().name());
        } else if (includeDefaults) {
            builder.nullField("normalizer");
        }
    }

    public static final class KeywordFieldType
    extends StringFieldType {
        private NamedAnalyzer normalizer = null;

        public KeywordFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        protected KeywordFieldType(KeywordFieldType ref) {
            super(ref);
            this.normalizer = ref.normalizer;
        }

        @Override
        public KeywordFieldType clone() {
            return new KeywordFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            return Objects.equals((Object)this.normalizer, (Object)((KeywordFieldType)((Object)o)).normalizer);
        }

        @Override
        public void checkCompatibility(MappedFieldType otherFT, List<String> conflicts, boolean strict) {
            super.checkCompatibility(otherFT, conflicts, strict);
            KeywordFieldType other = (KeywordFieldType)otherFT;
            if (!Objects.equals((Object)this.normalizer, (Object)other.normalizer)) {
                conflicts.add("mapper [" + this.name() + "] has different [normalizer]");
            }
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Objects.hashCode((Object)this.normalizer);
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        public NamedAnalyzer normalizer() {
            return this.normalizer;
        }

        public void setNormalizer(NamedAnalyzer normalizer) {
            this.checkIfFrozen();
            this.normalizer = normalizer;
        }

        @Override
        public Query nullValueQuery() {
            if (this.nullValue() == null) {
                return null;
            }
            return this.termQuery(this.nullValue(), null);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.searchAnalyzer().normalize(this.name(), value.toString());
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, KeywordFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;
        protected int ignoreAbove = Integer.MAX_VALUE;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public KeywordFieldType fieldType() {
            return (KeywordFieldType)super.fieldType();
        }

        public Builder ignoreAbove(int ignoreAbove) {
            if (ignoreAbove < 0) {
                throw new IllegalArgumentException("[ignore_above] must be positive, got " + ignoreAbove);
            }
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        @Override
        public Builder indexOptions(IndexOptions indexOptions) {
            if (indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) > 0) {
                throw new IllegalArgumentException("The [keyword] field does not support positions, got [index_options]=" + FieldMapper.indexOptionToString(indexOptions));
            }
            return (Builder)super.indexOptions(indexOptions);
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.fieldType().setEagerGlobalOrdinals(eagerGlobalOrdinals);
            return (Builder)this.builder;
        }

        public Builder normalizer(NamedAnalyzer normalizer) {
            this.fieldType().setNormalizer(normalizer);
            this.fieldType().setSearchAnalyzer(normalizer);
            return (Builder)this.builder;
        }

        @Override
        public KeywordFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new KeywordFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreAbove, this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new KeywordFieldType();
        public static final String NULL_VALUE;
        public static final int IGNORE_ABOVE = Integer.MAX_VALUE;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

