/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.mapper;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.codelibs.elasticsearch.Version;
import org.codelibs.elasticsearch.common.collect.ImmutableOpenMap;
import org.codelibs.elasticsearch.common.lucene.Lucene;
import org.codelibs.elasticsearch.common.settings.Setting;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.analysis.NamedAnalyzer;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;
import org.codelibs.elasticsearch.index.mapper.Mapper;

public abstract class FieldMapper
extends Mapper
implements Cloneable {
    public static final Setting<Boolean> IGNORE_MALFORMED_SETTING = Setting.boolSetting("index.mapping.ignore_malformed", false, Setting.Property.IndexScope);
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", false, Setting.Property.IndexScope);
    private final Version indexCreatedVersion;
    protected MappedFieldType fieldType;
    protected final MappedFieldType defaultFieldType;
    protected MultiFields multiFields;
    protected CopyTo copyTo;

    protected FieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, MultiFields multiFields, CopyTo copyTo) {
        super(simpleName);
        assert (indexSettings != null);
        this.indexCreatedVersion = Version.indexCreated(indexSettings);
        if (this.indexCreatedVersion.onOrAfter(Version.V_5_0_0_beta1) && simpleName.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty string");
        }
        fieldType.freeze();
        this.fieldType = fieldType;
        defaultFieldType.freeze();
        this.defaultFieldType = defaultFieldType;
        this.multiFields = multiFields;
        this.copyTo = copyTo;
    }

    @Override
    public String name() {
        return this.fieldType().name();
    }

    public MappedFieldType fieldType() {
        return this.fieldType;
    }

    public CopyTo copyTo() {
        return this.copyTo;
    }

    protected boolean customBoost() {
        return false;
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.multiFields.iterator();
    }

    protected FieldMapper clone() {
        try {
            return (FieldMapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public FieldMapper merge(Mapper mergeWith, boolean updateAllTypes) {
        FieldMapper merged = this.clone();
        merged.doMerge(mergeWith, updateAllTypes);
        return merged;
    }

    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        if (!this.getClass().equals(mergeWith.getClass())) {
            String mergedType = mergeWith.getClass().getSimpleName();
            if (mergeWith instanceof FieldMapper) {
                mergedType = ((FieldMapper)mergeWith).contentType();
            }
            throw new IllegalArgumentException("mapper [" + this.fieldType().name() + "] of different type, current_type [" + this.contentType() + "], merged_type [" + mergedType + "]");
        }
        FieldMapper fieldMergeWith = (FieldMapper)mergeWith;
        this.multiFields = this.multiFields.merge(fieldMergeWith.multiFields);
        this.fieldType = fieldMergeWith.fieldType;
        this.copyTo = fieldMergeWith.copyTo;
    }

    @Override
    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        MappedFieldType newFieldType = fullNameToFieldType.get(this.fieldType.name());
        if (newFieldType == null) {
            return this;
        }
        if (((Object)((Object)this.fieldType)).getClass() != ((Object)((Object)newFieldType)).getClass()) {
            throw new IllegalStateException("Mixing up field types: " + ((Object)((Object)this.fieldType)).getClass() + " != " + ((Object)((Object)newFieldType)).getClass() + " on field " + this.fieldType.name());
        }
        MultiFields updatedMultiFields = this.multiFields.updateFieldType(fullNameToFieldType);
        if (this.fieldType == newFieldType && this.multiFields == updatedMultiFields) {
            return this;
        }
        FieldMapper updated = this.clone();
        updated.fieldType = newFieldType;
        updated.multiFields = updatedMultiFields;
        return updated;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.doXContentBody(builder, includeDefaults, params);
        return builder.endObject();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected final void doXContentAnalyzers(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (!this.fieldType.tokenized()) {
            return;
        }
        if (this.fieldType().indexAnalyzer() == null) {
            if (includeDefaults) {
                builder.field("analyzer", "default");
            }
        } else {
            boolean hasDifferentSearchQuoteAnalyzer;
            boolean hasDefaultIndexAnalyzer = this.fieldType().indexAnalyzer().name().equals("default");
            boolean hasDifferentSearchAnalyzer = !this.fieldType().searchAnalyzer().name().equals(this.fieldType().indexAnalyzer().name());
            boolean bl = hasDifferentSearchQuoteAnalyzer = !this.fieldType().searchAnalyzer().name().equals(this.fieldType().searchQuoteAnalyzer().name());
            if (includeDefaults || !hasDefaultIndexAnalyzer || hasDifferentSearchAnalyzer || hasDifferentSearchQuoteAnalyzer) {
                builder.field("analyzer", this.fieldType().indexAnalyzer().name());
                if (includeDefaults || hasDifferentSearchAnalyzer || hasDifferentSearchQuoteAnalyzer) {
                    builder.field("search_analyzer", this.fieldType().searchAnalyzer().name());
                    if (includeDefaults || hasDifferentSearchQuoteAnalyzer) {
                        builder.field("search_quote_analyzer", this.fieldType().searchQuoteAnalyzer().name());
                    }
                }
            }
        }
    }

    protected void doXContentDocValues(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (includeDefaults || this.defaultFieldType.hasDocValues() != this.fieldType().hasDocValues()) {
            builder.field("doc_values", this.fieldType().hasDocValues());
        }
    }

    protected static String indexOptionToString(IndexOptions indexOption) {
        throw new UnsupportedOperationException();
    }

    public static String termVectorOptionsToString(FieldType fieldType) {
        if (!fieldType.storeTermVectors()) {
            return "no";
        }
        if (!fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "yes";
        }
        if (fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "with_offsets";
        }
        StringBuilder builder = new StringBuilder("with");
        if (fieldType.storeTermVectorPositions()) {
            builder.append("_positions");
        }
        if (fieldType.storeTermVectorOffsets()) {
            builder.append("_offsets");
        }
        if (fieldType.storeTermVectorPayloads()) {
            builder.append("_payloads");
        }
        return builder.toString();
    }

    protected Object indexTokenizeOption(boolean indexed, boolean tokenized) {
        return indexed;
    }

    protected abstract String contentType();

    public static class CopyTo {
        private final List<String> copyToFields;

        private CopyTo(List<String> copyToFields) {
            this.copyToFields = copyToFields;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.copyToFields.isEmpty()) {
                builder.startArray("copy_to");
                for (String field : this.copyToFields) {
                    builder.value(field);
                }
                builder.endArray();
            }
            return builder;
        }

        public List<String> copyToFields() {
            return this.copyToFields;
        }

        public static class Builder {
            private final List<String> copyToBuilders = new ArrayList<String>();

            public Builder add(String field) {
                this.copyToBuilders.add(field);
                return this;
            }

            public CopyTo build() {
                return new CopyTo(Collections.unmodifiableList(this.copyToBuilders));
            }
        }
    }

    public static class MultiFields {
        private final ImmutableOpenMap<String, FieldMapper> mappers;

        public static MultiFields empty() {
            return new MultiFields(ImmutableOpenMap.of());
        }

        private MultiFields(ImmutableOpenMap<String, FieldMapper> mappers) {
            ImmutableOpenMap.Builder<Object, Object> builder = new ImmutableOpenMap.Builder<Object, Object>();
            for (ObjectObjectCursor<String, FieldMapper> objectObjectCursor : mappers) {
                builder.put(objectObjectCursor.key, objectObjectCursor.value);
            }
            this.mappers = builder.build();
        }

        public MultiFields merge(MultiFields mergeWith) {
            ImmutableOpenMap.Builder<String, FieldMapper> newMappersBuilder = ImmutableOpenMap.builder(this.mappers);
            for (ObjectCursor cursor : mergeWith.mappers.values()) {
                FieldMapper mergeWithMapper = (FieldMapper)cursor.value;
                FieldMapper mergeIntoMapper = this.mappers.get(mergeWithMapper.simpleName());
                if (mergeIntoMapper == null) {
                    newMappersBuilder.put(mergeWithMapper.simpleName(), mergeWithMapper);
                    continue;
                }
                FieldMapper merged = mergeIntoMapper.merge(mergeWithMapper, false);
                newMappersBuilder.put(merged.simpleName(), merged);
            }
            ImmutableOpenMap<String, FieldMapper> mappers = newMappersBuilder.build();
            return new MultiFields(mappers);
        }

        public MultiFields updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
            ImmutableOpenMap.Builder<String, FieldMapper> newMappersBuilder = null;
            for (ObjectCursor cursor : this.mappers.values()) {
                Mapper updated = ((FieldMapper)cursor.value).updateFieldType((Map)fullNameToFieldType);
                if (updated == cursor.value) continue;
                if (newMappersBuilder == null) {
                    newMappersBuilder = ImmutableOpenMap.builder(this.mappers);
                }
                newMappersBuilder.put(updated.simpleName(), (FieldMapper)updated);
            }
            if (newMappersBuilder == null) {
                return this;
            }
            ImmutableOpenMap<String, FieldMapper> mappers = newMappersBuilder.build();
            return new MultiFields(mappers);
        }

        public Iterator<Mapper> iterator() {
            return StreamSupport.stream(this.mappers.values().spliterator(), false).map(p -> (Mapper)p.value).iterator();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.mappers.isEmpty()) {
                Mapper[] sortedMappers = (Mapper[])this.mappers.values().toArray(Mapper.class);
                Arrays.sort(sortedMappers, (o1, o2) -> o1.name().compareTo(o2.name()));
                builder.startObject("fields");
                for (Mapper mapper : sortedMappers) {
                    mapper.toXContent(builder, params);
                }
                builder.endObject();
            }
            return builder;
        }

        public static class Builder {
            private final ImmutableOpenMap.Builder<String, Mapper.Builder> mapperBuilders = ImmutableOpenMap.builder();

            public Builder add(Mapper.Builder builder) {
                this.mapperBuilders.put(builder.name(), builder);
                return this;
            }

            public MultiFields build(org.codelibs.elasticsearch.index.mapper.FieldMapper$Builder mainFieldBuilder, Mapper.BuilderContext context) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static abstract class Builder<T extends Builder, Y extends FieldMapper>
    extends Mapper.Builder<T, Y> {
        protected final MappedFieldType fieldType;
        protected final MappedFieldType defaultFieldType;
        private final IndexOptions defaultOptions;
        protected boolean omitNormsSet = false;
        protected Boolean includeInAll;
        protected boolean indexOptionsSet = false;
        protected boolean docValuesSet = false;
        protected final MultiFields.Builder multiFieldsBuilder;
        protected CopyTo copyTo;

        protected Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType) {
            super(name);
            this.fieldType = fieldType.clone();
            this.defaultFieldType = defaultFieldType.clone();
            this.defaultOptions = fieldType.indexOptions();
            this.docValuesSet = fieldType.hasDocValues();
            this.multiFieldsBuilder = new MultiFields.Builder();
        }

        public MappedFieldType fieldType() {
            return this.fieldType;
        }

        public T index(boolean index) {
            if (index) {
                if (this.fieldType.indexOptions() == IndexOptions.NONE) {
                    IndexOptions options = this.getDefaultIndexOption();
                    if (options == IndexOptions.NONE) {
                        throw new IllegalArgumentException("mapper [" + this.name + "] has different [index] values from other types of the same index");
                    }
                    this.fieldType.setIndexOptions(options);
                }
            } else {
                this.fieldType.setIndexOptions(IndexOptions.NONE);
            }
            return (T)((Builder)this.builder);
        }

        protected IndexOptions getDefaultIndexOption() {
            return this.defaultOptions;
        }

        public T store(boolean store) {
            this.fieldType.setStored(store);
            return (T)((Builder)this.builder);
        }

        public T docValues(boolean docValues) {
            this.fieldType.setHasDocValues(docValues);
            this.docValuesSet = true;
            return (T)((Builder)this.builder);
        }

        public T storeTermVectors(boolean termVectors) {
            if (termVectors != this.fieldType.storeTermVectors()) {
                this.fieldType.setStoreTermVectors(termVectors);
            }
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorOffsets(boolean termVectorOffsets) {
            if (termVectorOffsets) {
                this.fieldType.setStoreTermVectors(termVectorOffsets);
            }
            this.fieldType.setStoreTermVectorOffsets(termVectorOffsets);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPositions(boolean termVectorPositions) {
            if (termVectorPositions) {
                this.fieldType.setStoreTermVectors(termVectorPositions);
            }
            this.fieldType.setStoreTermVectorPositions(termVectorPositions);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPayloads(boolean termVectorPayloads) {
            if (termVectorPayloads) {
                this.fieldType.setStoreTermVectors(termVectorPayloads);
            }
            this.fieldType.setStoreTermVectorPayloads(termVectorPayloads);
            return (T)((Builder)this.builder);
        }

        public T tokenized(boolean tokenized) {
            this.fieldType.setTokenized(tokenized);
            return (T)((Builder)this.builder);
        }

        public T boost(float boost) {
            this.fieldType.setBoost(boost);
            return (T)((Builder)this.builder);
        }

        public T omitNorms(boolean omitNorms) {
            this.fieldType.setOmitNorms(omitNorms);
            this.omitNormsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexOptions(IndexOptions indexOptions) {
            this.fieldType.setIndexOptions(indexOptions);
            this.indexOptionsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.fieldType.setIndexAnalyzer(indexAnalyzer);
            return (T)((Builder)this.builder);
        }

        public T searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.fieldType.setSearchAnalyzer(searchAnalyzer);
            return (T)((Builder)this.builder);
        }

        public T searchQuoteAnalyzer(NamedAnalyzer searchQuoteAnalyzer) {
            this.fieldType.setSearchQuoteAnalyzer(searchQuoteAnalyzer);
            return (T)((Builder)this.builder);
        }

        public T includeInAll(Boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        public Builder nullValue(Object nullValue) {
            this.fieldType.setNullValue(nullValue);
            return this;
        }

        public T addMultiField(Mapper.Builder mapperBuilder) {
            this.multiFieldsBuilder.add(mapperBuilder);
            return (T)((Builder)this.builder);
        }

        public T copyTo(CopyTo copyTo) {
            this.copyTo = copyTo;
            return (T)((Builder)this.builder);
        }

        protected String buildFullName(Mapper.BuilderContext context) {
            throw new UnsupportedOperationException();
        }

        protected boolean defaultDocValues(Version indexCreated) {
            if (indexCreated.onOrAfter(Version.V_5_0_0_alpha1)) {
                return !this.fieldType.tokenized();
            }
            return !this.fieldType.tokenized() && this.fieldType.indexOptions() != IndexOptions.NONE;
        }

        protected void setupFieldType(Mapper.BuilderContext context) {
            this.fieldType.setName(this.buildFullName(context));
            if (context.indexCreatedVersion().before(Version.V_5_0_0_alpha1)) {
                this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.fieldType.boost() == 1.0f);
            }
            if (this.fieldType.indexAnalyzer() == null && !this.fieldType.tokenized() && this.fieldType.indexOptions() != IndexOptions.NONE) {
                this.fieldType.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
                this.fieldType.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            }
            boolean defaultDocValues = this.defaultDocValues(context.indexCreatedVersion());
            this.defaultFieldType.setHasDocValues(defaultDocValues);
            if (!this.docValuesSet) {
                this.fieldType.setHasDocValues(defaultDocValues);
            }
        }
    }
}

