/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.Query;
import org.codelibs.elasticsearch.action.fieldstats.FieldStats;
import org.codelibs.elasticsearch.common.Explicit;
import org.codelibs.elasticsearch.common.Nullable;
import org.codelibs.elasticsearch.common.logging.DeprecationLogger;
import org.codelibs.elasticsearch.common.logging.Loggers;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.index.fielddata.IndexFieldData;
import org.codelibs.elasticsearch.index.mapper.FieldMapper;
import org.codelibs.elasticsearch.index.mapper.MappedFieldType;
import org.codelibs.elasticsearch.index.mapper.Mapper;
import org.codelibs.elasticsearch.index.query.QueryShardContext;
import org.codelibs.elasticsearch.index.query.QueryShardException;
import org.codelibs.elasticsearch.search.DocValueFormat;
import org.joda.time.DateTimeZone;

public abstract class BaseGeoPointFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "geo_point";
    protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(BaseGeoPointFieldMapper.class));
    protected FieldMapper latMapper;
    protected FieldMapper lonMapper;
    protected FieldMapper geoHashMapper;
    protected Explicit<Boolean> ignoreMalformed;

    protected BaseGeoPointFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper latMapper, FieldMapper lonMapper, FieldMapper geoHashMapper, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.latMapper = latMapper;
        this.lonMapper = lonMapper;
        this.geoHashMapper = geoHashMapper;
        this.ignoreMalformed = ignoreMalformed;
    }

    public LegacyGeoPointFieldType legacyFieldType() {
        return (LegacyGeoPointFieldType)super.fieldType();
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        BaseGeoPointFieldMapper gpfmMergeWith = (BaseGeoPointFieldMapper)mergeWith;
        if (gpfmMergeWith.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gpfmMergeWith.ignoreMalformed;
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        throw new UnsupportedOperationException();
    }

    public Iterator<Mapper> legacyIterator() {
        ArrayList<FieldMapper> extras = new ArrayList<FieldMapper>();
        if (this.legacyFieldType().isGeoHashEnabled()) {
            extras.add(this.geoHashMapper);
        }
        if (this.legacyFieldType().isLatLonEnabled()) {
            extras.add(this.latMapper);
            extras.add(this.lonMapper);
        }
        return extras.iterator();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        Mapper lonUpdated;
        BaseGeoPointFieldMapper updated = (BaseGeoPointFieldMapper)super.updateFieldType((Map)fullNameToFieldType);
        Mapper geoUpdated = this.geoHashMapper == null ? null : this.geoHashMapper.updateFieldType((Map)fullNameToFieldType);
        Mapper latUpdated = this.latMapper == null ? null : this.latMapper.updateFieldType((Map)fullNameToFieldType);
        Mapper mapper = lonUpdated = this.lonMapper == null ? null : this.lonMapper.updateFieldType((Map)fullNameToFieldType);
        if (updated == this && geoUpdated == this.geoHashMapper && latUpdated == this.latMapper && lonUpdated == this.lonMapper) {
            return this;
        }
        if (updated == this) {
            updated = (BaseGeoPointFieldMapper)updated.clone();
        }
        updated.geoHashMapper = geoUpdated;
        updated.latMapper = latUpdated;
        updated.lonMapper = lonUpdated;
        return updated;
    }

    public static class LegacyGeoPointFieldType
    extends GeoPointFieldType {
        protected MappedFieldType geoHashFieldType;
        protected int geoHashPrecision;
        protected boolean geoHashPrefixEnabled;
        protected MappedFieldType latFieldType;
        protected MappedFieldType lonFieldType;

        LegacyGeoPointFieldType() {
        }

        LegacyGeoPointFieldType(LegacyGeoPointFieldType ref) {
            super(ref);
            this.geoHashFieldType = ref.geoHashFieldType;
            this.geoHashPrecision = ref.geoHashPrecision;
            this.geoHashPrefixEnabled = ref.geoHashPrefixEnabled;
            this.latFieldType = ref.latFieldType;
            this.lonFieldType = ref.lonFieldType;
        }

        @Override
        public MappedFieldType clone() {
            return new LegacyGeoPointFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            LegacyGeoPointFieldType that = (LegacyGeoPointFieldType)((Object)o);
            return this.geoHashPrecision == that.geoHashPrecision && this.geoHashPrefixEnabled == that.geoHashPrefixEnabled && Objects.equals((Object)this.geoHashFieldType, (Object)that.geoHashFieldType) && Objects.equals((Object)this.latFieldType, (Object)that.latFieldType) && Objects.equals((Object)this.lonFieldType, (Object)that.lonFieldType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.geoHashFieldType, this.geoHashPrecision, this.geoHashPrefixEnabled, this.latFieldType, this.lonFieldType});
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            LegacyGeoPointFieldType other = (LegacyGeoPointFieldType)fieldType;
            if (this.isLatLonEnabled() != other.isLatLonEnabled()) {
                conflicts.add("mapper [" + this.name() + "] has different [lat_lon]");
            }
            if (this.isLatLonEnabled() && other.isLatLonEnabled() && this.latFieldType().numericPrecisionStep() != other.latFieldType().numericPrecisionStep()) {
                conflicts.add("mapper [" + this.name() + "] has different [precision_step]");
            }
            if (this.isGeoHashEnabled() != other.isGeoHashEnabled()) {
                conflicts.add("mapper [" + this.name() + "] has different [geohash]");
            }
            if (this.geoHashPrecision() != other.geoHashPrecision()) {
                conflicts.add("mapper [" + this.name() + "] has different [geohash_precision]");
            }
            if (this.isGeoHashPrefixEnabled() != other.isGeoHashPrefixEnabled()) {
                conflicts.add("mapper [" + this.name() + "] has different [geohash_prefix]");
            }
        }

        public boolean isGeoHashEnabled() {
            return this.geoHashFieldType != null;
        }

        public MappedFieldType geoHashFieldType() {
            return this.geoHashFieldType;
        }

        public int geoHashPrecision() {
            return this.geoHashPrecision;
        }

        public boolean isGeoHashPrefixEnabled() {
            return this.geoHashPrefixEnabled;
        }

        public void setGeoHashEnabled(MappedFieldType geoHashFieldType, int geoHashPrecision, boolean geoHashPrefixEnabled) {
            this.checkIfFrozen();
            this.geoHashFieldType = geoHashFieldType;
            this.geoHashPrecision = geoHashPrecision;
            this.geoHashPrefixEnabled = geoHashPrefixEnabled;
        }

        public boolean isLatLonEnabled() {
            return this.latFieldType != null;
        }

        public MappedFieldType latFieldType() {
            return this.latFieldType;
        }

        public MappedFieldType lonFieldType() {
            return this.lonFieldType;
        }

        public void setLatLonEnabled(MappedFieldType latFieldType, MappedFieldType lonFieldType) {
            this.checkIfFrozen();
            this.latFieldType = latFieldType;
            this.lonFieldType = lonFieldType;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, DateTimeZone timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.GEOHASH;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geo fields do not support exact searching, use dedicated geo queries instead: [" + this.name() + "]", new Object[0]);
        }
    }

    public static abstract class GeoPointFieldType
    extends MappedFieldType {
        GeoPointFieldType() {
        }

        GeoPointFieldType(GeoPointFieldType ref) {
            super(ref);
        }

        @Override
        public String typeName() {
            return BaseGeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public FieldStats stats(IndexReader reader) throws IOException {
            int maxDoc = reader.maxDoc();
            FieldInfo fi = MultiFields.getMergedFieldInfos((IndexReader)reader).fieldInfo(this.name());
            if (fi == null) {
                return null;
            }
            return new FieldStats.Text(maxDoc, -1L, -1L, -1L, this.isSearchable(), this.isAggregatable());
        }
    }

    public static abstract class TypeParser
    implements Mapper.TypeParser {
    }

    public static abstract class Builder<T extends Builder, Y extends BaseGeoPointFieldMapper>
    extends FieldMapper.Builder<T, Y> {
        protected boolean enableLatLon = false;
        protected Integer precisionStep;
        protected boolean enableGeoHash = false;
        protected boolean enableGeoHashPrefix = false;
        protected int geoHashPrecision = 12;
        protected Boolean ignoreMalformed;

        public Builder(String name, MappedFieldType fieldType) {
            super(name, fieldType, fieldType);
        }

        @Override
        public GeoPointFieldType fieldType() {
            return (GeoPointFieldType)this.fieldType;
        }

        public T enableLatLon(boolean enableLatLon) {
            this.enableLatLon = enableLatLon;
            return (T)((Builder)this.builder);
        }

        public T precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return (T)((Builder)this.builder);
        }

        public T enableGeoHash(boolean enableGeoHash) {
            this.enableGeoHash = enableGeoHash;
            return (T)((Builder)this.builder);
        }

        public T geoHashPrefix(boolean enableGeoHashPrefix) {
            this.enableGeoHashPrefix = enableGeoHashPrefix;
            return (T)((Builder)this.builder);
        }

        public T geoHashPrecision(int precision) {
            this.geoHashPrecision = precision;
            return (T)((Builder)this.builder);
        }

        public T ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public abstract Y build(Mapper.BuilderContext var1, String var2, MappedFieldType var3, MappedFieldType var4, Settings var5, FieldMapper var6, FieldMapper var7, FieldMapper var8, FieldMapper.MultiFields var9, Explicit<Boolean> var10, FieldMapper.CopyTo var11);

        @Override
        public Y build(Mapper.BuilderContext context) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Defaults {
        public static final boolean ENABLE_LATLON = false;
        public static final boolean ENABLE_GEOHASH = false;
        public static final boolean ENABLE_GEOHASH_PREFIX = false;
        public static final int GEO_HASH_PRECISION = 12;
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
    }

    public static class Names {
        public static final String LAT = "lat";
        public static final String LAT_SUFFIX = ".lat";
        public static final String LON = "lon";
        public static final String LON_SUFFIX = ".lon";
        public static final String GEOHASH = "geohash";
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }
}

