/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.codelibs.elasticsearch.common.Nullable;
import org.codelibs.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.codelibs.elasticsearch.index.fielddata.IndexFieldData;
import org.codelibs.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.codelibs.elasticsearch.index.fielddata.NumericDoubleValues;
import org.codelibs.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.codelibs.elasticsearch.search.MultiValueMode;

public class DoubleValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;
    private final Object missingValue;
    private final MultiValueMode sortMode;
    private final IndexFieldData.XFieldComparatorSource.Nested nested;

    public DoubleValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
        this.nested = nested;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.DOUBLE;
    }

    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
        return ((AtomicNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
    }

    protected void setScorer(Scorer scorer) {
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final double dMissingValue = (Double)this.missingObject(this.missingValue, reversed);
        return new FieldComparator.DoubleComparator(numHits, null, null){

            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                NumericDoubleValues selectedValues;
                SortedNumericDoubleValues values = DoubleValuesComparatorSource.this.getValues(context);
                if (DoubleValuesComparatorSource.this.nested == null) {
                    selectedValues = DoubleValuesComparatorSource.this.sortMode.select(values, dMissingValue);
                } else {
                    BitSet rootDocs = DoubleValuesComparatorSource.this.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = DoubleValuesComparatorSource.this.nested.innerDocs(context);
                    selectedValues = DoubleValuesComparatorSource.this.sortMode.select(values, dMissingValue, rootDocs, innerDocs, context.reader().maxDoc());
                }
                return selectedValues.getRawDoubleValues();
            }

            public void setScorer(Scorer scorer) {
                DoubleValuesComparatorSource.this.setScorer(scorer);
            }
        };
    }
}

