/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.index;

import java.io.IOException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;

public abstract class VersionType
extends Enum<VersionType>
implements Writeable {
    public static final /* enum */ VersionType INTERNAL = new VersionType(0){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            return this.isVersionConflict(currentVersion, expectedVersion, deleted);
        }

        @Override
        public String explainConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            if (expectedVersion == -4L) {
                return "document already exists (current version [" + currentVersion + "])";
            }
            return "current version [" + currentVersion + "] is different than the one provided [" + expectedVersion + "]";
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            return this.isVersionConflict(currentVersion, expectedVersion, false);
        }

        @Override
        public String explainConflictForReads(long currentVersion, long expectedVersion) {
            return "current version [" + currentVersion + "] is different than the one provided [" + expectedVersion + "]";
        }

        private boolean isVersionConflict(long currentVersion, long expectedVersion, boolean deleted) {
            if (expectedVersion == -3L) {
                return false;
            }
            if (expectedVersion == -4L) {
                return !deleted;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return currentVersion == -1L ? 1L : currentVersion + 1L;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version > 0L || version == -3L || version == -4L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version > 0L || version == -3L;
        }

        @Override
        public VersionType versionTypeForReplicationAndRecovery() {
            return EXTERNAL;
        }
    };
    public static final /* enum */ VersionType EXTERNAL = new VersionType(1){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            if (currentVersion == -1L) {
                return false;
            }
            if (expectedVersion == -3L) {
                return true;
            }
            return currentVersion >= expectedVersion;
        }

        @Override
        public String explainConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            return "current version [" + currentVersion + "] is higher or equal to the one provided [" + expectedVersion + "]";
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            if (expectedVersion == -3L) {
                return false;
            }
            if (currentVersion == -1L) {
                return true;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public String explainConflictForReads(long currentVersion, long expectedVersion) {
            return "current version [" + currentVersion + "] is different than the one provided [" + expectedVersion + "]";
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version >= 0L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version >= 0L || version == -3L;
        }
    };
    public static final /* enum */ VersionType EXTERNAL_GTE = new VersionType(2){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            if (currentVersion == -1L) {
                return false;
            }
            if (expectedVersion == -3L) {
                return true;
            }
            return currentVersion > expectedVersion;
        }

        @Override
        public String explainConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            return "current version [" + currentVersion + "] is higher than the one provided [" + expectedVersion + "]";
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            if (expectedVersion == -3L) {
                return false;
            }
            if (currentVersion == -1L) {
                return true;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public String explainConflictForReads(long currentVersion, long expectedVersion) {
            return "current version [" + currentVersion + "] is different than the one provided [" + expectedVersion + "]";
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version >= 0L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version >= 0L || version == -3L;
        }
    };
    @Deprecated
    public static final /* enum */ VersionType FORCE = new VersionType(3){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            if (currentVersion == -1L) {
                return false;
            }
            if (expectedVersion == -3L) {
                throw new IllegalStateException("you must specify a version when use VersionType.FORCE");
            }
            return false;
        }

        @Override
        public String explainConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            throw new AssertionError((Object)"VersionType.FORCE should never result in a write conflict");
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            return false;
        }

        @Override
        public String explainConflictForReads(long currentVersion, long expectedVersion) {
            throw new AssertionError((Object)"VersionType.FORCE should never result in a read conflict");
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version >= 0L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version >= 0L || version == -3L;
        }
    };
    private final byte value;
    private static final /* synthetic */ VersionType[] $VALUES;

    public static VersionType[] values() {
        return (VersionType[])$VALUES.clone();
    }

    public static VersionType valueOf(String name) {
        return Enum.valueOf(VersionType.class, name);
    }

    private VersionType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public abstract boolean isVersionConflictForWrites(long var1, long var3, boolean var5);

    public abstract String explainConflictForWrites(long var1, long var3, boolean var5);

    public abstract boolean isVersionConflictForReads(long var1, long var3);

    public abstract String explainConflictForReads(long var1, long var3);

    public abstract long updateVersion(long var1, long var3);

    public abstract boolean validateVersionForWrites(long var1);

    public abstract boolean validateVersionForReads(long var1);

    public VersionType versionTypeForReplicationAndRecovery() {
        return this;
    }

    public static VersionType fromString(String versionType) {
        if ("internal".equals(versionType)) {
            return INTERNAL;
        }
        if ("external".equals(versionType)) {
            return EXTERNAL;
        }
        if ("external_gt".equals(versionType)) {
            return EXTERNAL;
        }
        if ("external_gte".equals(versionType)) {
            return EXTERNAL_GTE;
        }
        if ("force".equals(versionType)) {
            return FORCE;
        }
        throw new IllegalArgumentException("No version type match [" + versionType + "]");
    }

    public static VersionType fromString(String versionType, VersionType defaultVersionType) {
        if (versionType == null) {
            return defaultVersionType;
        }
        return VersionType.fromString(versionType);
    }

    public static VersionType fromValue(byte value) {
        if (value == 0) {
            return INTERNAL;
        }
        if (value == 1) {
            return EXTERNAL;
        }
        if (value == 2) {
            return EXTERNAL_GTE;
        }
        if (value == 3) {
            return FORCE;
        }
        throw new IllegalArgumentException("No version type match [" + value + "]");
    }

    public static VersionType readFromStream(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        assert (ordinal == 0 || ordinal == 1 || ordinal == 2 || ordinal == 3);
        return VersionType.values()[ordinal];
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    static {
        $VALUES = new VersionType[]{INTERNAL, EXTERNAL, EXTERNAL_GTE, FORCE};
    }
}

