/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.xcontent.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Set;
import org.codelibs.elasticsearch.common.bytes.BytesReference;
import org.codelibs.elasticsearch.common.io.FastStringReader;
import org.codelibs.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.codelibs.elasticsearch.common.xcontent.XContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentGenerator;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.common.xcontent.XContentType;
import org.codelibs.elasticsearch.common.xcontent.json.JsonXContentGenerator;
import org.codelibs.elasticsearch.common.xcontent.json.JsonXContentParser;

public class JsonXContent
implements XContent {
    private static final JsonFactory jsonFactory = new JsonFactory();
    public static final String JSON_ALLOW_UNQUOTED_FIELD_NAMES = "elasticsearch.json.allow_unquoted_field_names";
    public static final JsonXContent jsonXContent;
    public static final boolean unquotedFieldNamesSet;

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder(jsonXContent);
    }

    private JsonXContent() {
    }

    @Override
    public XContentType type() {
        return XContentType.JSON;
    }

    @Override
    public byte streamSeparator() {
        return 10;
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new JsonXContentGenerator(jsonFactory.createGenerator(os, JsonEncoding.UTF8), os, includes, excludes);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, String content) throws IOException {
        return new JsonXContentParser(xContentRegistry, jsonFactory.createParser((Reader)new FastStringReader(content)));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, InputStream is) throws IOException {
        return new JsonXContentParser(xContentRegistry, jsonFactory.createParser(is));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, byte[] data) throws IOException {
        return new JsonXContentParser(xContentRegistry, jsonFactory.createParser(data));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, byte[] data, int offset, int length) throws IOException {
        return new JsonXContentParser(xContentRegistry, jsonFactory.createParser(data, offset, length));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, BytesReference bytes) throws IOException {
        return this.createParser(xContentRegistry, bytes.streamInput());
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, Reader reader) throws IOException {
        return new JsonXContentParser(xContentRegistry, jsonFactory.createParser(reader));
    }

    static {
        String jsonUnquoteProp = System.getProperty(JSON_ALLOW_UNQUOTED_FIELD_NAMES);
        if (jsonUnquoteProp == null) {
            unquotedFieldNamesSet = false;
            jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, false);
        } else {
            unquotedFieldNamesSet = true;
            switch (jsonUnquoteProp) {
                case "true": {
                    jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
                    break;
                }
                case "false": {
                    jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid value for [elasticsearch.json.allow_unquoted_field_names]: " + jsonUnquoteProp);
                }
            }
        }
        jsonFactory.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        jsonFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        jsonXContent = new JsonXContent();
    }
}

