/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.Locale;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.xcontent.XContent;
import org.codelibs.elasticsearch.common.xcontent.cbor.CborXContent;
import org.codelibs.elasticsearch.common.xcontent.json.JsonXContent;
import org.codelibs.elasticsearch.common.xcontent.smile.SmileXContent;
import org.codelibs.elasticsearch.common.xcontent.yaml.YamlXContent;

public enum XContentType implements Writeable
{
    JSON(0){

        @Override
        protected String mediaTypeWithoutParameters() {
            return "application/json";
        }

        @Override
        public String mediaType() {
            return "application/json; charset=UTF-8";
        }

        @Override
        public String shortName() {
            return "json";
        }

        @Override
        public XContent xContent() {
            return JsonXContent.jsonXContent;
        }
    }
    ,
    SMILE(1){

        @Override
        protected String mediaTypeWithoutParameters() {
            return "application/smile";
        }

        @Override
        public String shortName() {
            return "smile";
        }

        @Override
        public XContent xContent() {
            return SmileXContent.smileXContent;
        }
    }
    ,
    YAML(2){

        @Override
        protected String mediaTypeWithoutParameters() {
            return "application/yaml";
        }

        @Override
        public String shortName() {
            return "yaml";
        }

        @Override
        public XContent xContent() {
            return YamlXContent.yamlXContent;
        }
    }
    ,
    CBOR(3){

        @Override
        protected String mediaTypeWithoutParameters() {
            return "application/cbor";
        }

        @Override
        public String shortName() {
            return "cbor";
        }

        @Override
        public XContent xContent() {
            return CborXContent.cborXContent;
        }
    };

    private int index;

    public static XContentType fromMediaTypeOrFormat(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        for (XContentType type : XContentType.values()) {
            if (!XContentType.isSameMediaTypeAs(mediaType, type)) continue;
            return type;
        }
        if (mediaType.toLowerCase(Locale.ROOT).startsWith("application/*")) {
            return JSON;
        }
        return null;
    }

    private static boolean isSameMediaTypeAs(String stringType, XContentType type) {
        return type.mediaTypeWithoutParameters().equalsIgnoreCase(stringType) || stringType.toLowerCase(Locale.ROOT).startsWith(type.mediaTypeWithoutParameters().toLowerCase(Locale.ROOT) + ";") || type.shortName().equalsIgnoreCase(stringType);
    }

    private XContentType(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public String mediaType() {
        return this.mediaTypeWithoutParameters();
    }

    public abstract String shortName();

    public abstract XContent xContent();

    protected abstract String mediaTypeWithoutParameters();

    public static XContentType readFrom(StreamInput in) throws IOException {
        int index = in.readVInt();
        for (XContentType contentType : XContentType.values()) {
            if (index != contentType.index) continue;
            return contentType;
        }
        throw new IllegalStateException("Unknown XContentType with index [" + index + "]");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.index);
    }
}

