/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.Locale;
import java.util.function.Supplier;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.xcontent.XContentLocation;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;

public final class XContentParserUtils {
    private XContentParserUtils() {
    }

    public static void ensureFieldName(XContentParser parser, XContentParser.Token token, String fieldName) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        String currentName = parser.currentName();
        if (!currentName.equals(fieldName)) {
            String message = "Failed to parse object: expecting field with name [%s] but found [%s]";
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, message, fieldName, currentName), new Object[0]);
        }
    }

    public static void throwUnknownField(String field, XContentLocation location) {
        String message = "Failed to parse object: unknown field [%s] found";
        throw new ParsingException(location, String.format(Locale.ROOT, message, field), new Object[0]);
    }

    public static void ensureExpectedToken(XContentParser.Token expected, XContentParser.Token actual, Supplier<XContentLocation> location) {
        if (actual != expected) {
            String message = "Failed to parse object: expecting token of type [%s] but found [%s]";
            throw new ParsingException(location.get(), String.format(Locale.ROOT, message, new Object[]{expected, actual}), new Object[0]);
        }
    }
}

