/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.util.concurrent;

import java.io.IOException;
import org.codelibs.elasticsearch.ElasticsearchException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;

public class EsRejectedExecutionException
extends ElasticsearchException {
    private final boolean isExecutorShutdown;

    public EsRejectedExecutionException(String message, boolean isExecutorShutdown) {
        super(message, new Object[0]);
        this.isExecutorShutdown = isExecutorShutdown;
    }

    public EsRejectedExecutionException(String message) {
        this(message, false);
    }

    public EsRejectedExecutionException() {
        super((String)null, new Object[0]);
        this.isExecutorShutdown = false;
    }

    public EsRejectedExecutionException(Throwable e) {
        super(null, e, new Object[0]);
        this.isExecutorShutdown = false;
    }

    public EsRejectedExecutionException(StreamInput in) throws IOException {
        super(in);
        this.isExecutorShutdown = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.isExecutorShutdown);
    }

    public boolean isExecutorShutdown() {
        return this.isExecutorShutdown;
    }
}

