/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.util.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.codelibs.elasticsearch.ElasticsearchException;

public class AtomicArray<E> {
    private static final AtomicArray EMPTY = new AtomicArray(0);
    private final AtomicReferenceArray<E> array;
    private volatile List<Entry<E>> nonNullList;

    public static <E> E empty() {
        return (E)EMPTY;
    }

    public AtomicArray(int size) {
        this.array = new AtomicReferenceArray(size);
    }

    public int length() {
        return this.array.length();
    }

    public void set(int i, E value) {
        this.array.set(i, value);
        if (this.nonNullList != null) {
            this.nonNullList = null;
        }
    }

    public final void setOnce(int i, E value) {
        if (!this.array.compareAndSet(i, null, value)) {
            throw new IllegalStateException("index [" + i + "] has already been set");
        }
        if (this.nonNullList != null) {
            this.nonNullList = null;
        }
    }

    public E get(int i) {
        return this.array.get(i);
    }

    public List<Entry<E>> asList() {
        if (this.nonNullList == null) {
            if (this.array == null || this.array.length() == 0) {
                this.nonNullList = Collections.emptyList();
            } else {
                ArrayList<Entry<Entry<E>>> list = new ArrayList<Entry<Entry<E>>>(this.array.length());
                for (int i = 0; i < this.array.length(); ++i) {
                    E e = this.array.get(i);
                    if (e == null) continue;
                    list.add(new Entry<E>(i, e));
                }
                this.nonNullList = list;
            }
        }
        return this.nonNullList;
    }

    public E[] toArray(E[] a) {
        if (a.length != this.array.length()) {
            throw new ElasticsearchException("AtomicArrays can only be copied to arrays of the same size", new Object[0]);
        }
        for (int i = 0; i < this.array.length(); ++i) {
            a[i] = this.array.get(i);
        }
        return a;
    }

    public static class Entry<E> {
        public final int index;
        public final E value;

        public Entry(int index, E value) {
            this.index = index;
            this.value = value;
        }
    }
}

