/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.util;

import java.util.Locale;
import org.codelibs.elasticsearch.common.lease.Releasable;
import org.codelibs.elasticsearch.common.settings.Setting;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.common.unit.ByteSizeValue;

public class PageCacheRecycler
implements Releasable {
    public static final Setting<Type> TYPE_SETTING = new Setting<Type>("cache.recycler.page.type", Type.CONCURRENT.name(), Type::parse, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> LIMIT_HEAP_SETTING = Setting.memorySizeSetting("cache.recycler.page.limit.heap", "10%", Setting.Property.NodeScope);
    public static final Setting<Double> WEIGHT_BYTES_SETTING = Setting.doubleSetting("cache.recycler.page.weight.bytes", 1.0, 0.0, Setting.Property.NodeScope);
    public static final Setting<Double> WEIGHT_LONG_SETTING = Setting.doubleSetting("cache.recycler.page.weight.longs", 1.0, 0.0, Setting.Property.NodeScope);
    public static final Setting<Double> WEIGHT_INT_SETTING = Setting.doubleSetting("cache.recycler.page.weight.ints", 1.0, 0.0, Setting.Property.NodeScope);
    public static final Setting<Double> WEIGHT_OBJECTS_SETTING = Setting.doubleSetting("cache.recycler.page.weight.objects", 0.1, 0.0, Setting.Property.NodeScope);

    @Override
    public void close() {
    }

    protected PageCacheRecycler(Settings settings) {
        TYPE_SETTING.get(settings);
        long limit = LIMIT_HEAP_SETTING.get(settings).getBytes();
        double bytesWeight = WEIGHT_BYTES_SETTING.get(settings);
        double intsWeight = WEIGHT_INT_SETTING.get(settings);
        double longsWeight = WEIGHT_LONG_SETTING.get(settings);
        double objectsWeight = WEIGHT_OBJECTS_SETTING.get(settings);
        double totalWeight = bytesWeight + intsWeight + longsWeight + objectsWeight;
        int maxPageCount = (int)Math.min(Integer.MAX_VALUE, limit / 16384L);
        int maxBytePageCount = (int)(bytesWeight * (double)maxPageCount / totalWeight);
        int maxIntPageCount = (int)(intsWeight * (double)maxPageCount / totalWeight);
        int maxLongPageCount = (int)(longsWeight * (double)maxPageCount / totalWeight);
        int maxObjectPageCount = (int)(objectsWeight * (double)maxPageCount / totalWeight);
        assert ((long)(16384 * (maxBytePageCount + maxIntPageCount + maxLongPageCount + maxObjectPageCount)) <= limit);
    }

    public static enum Type {
        QUEUE{}
        ,
        CONCURRENT{}
        ,
        NONE{};


        public static Type parse(String type) {
            try {
                return Type.valueOf(type.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("no type support [" + type + "]");
            }
        }
    }
}

