/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.util;

import org.codelibs.elasticsearch.common.util.AbstractArray;
import org.codelibs.elasticsearch.common.util.BigArrays;

abstract class AbstractBigArray
extends AbstractArray {
    private final Object recycler;
    private final int pageShift;
    private final int pageMask;
    protected long size;

    protected AbstractBigArray(int pageSize, BigArrays bigArrays, boolean clearOnResize) {
        super(bigArrays, clearOnResize);
        this.recycler = bigArrays.recycler;
        if (pageSize < 128) {
            throw new IllegalArgumentException("pageSize must be >= 128");
        }
        if ((pageSize & pageSize - 1) != 0) {
            throw new IllegalArgumentException("pageSize must be a power of two");
        }
        this.pageShift = Integer.numberOfTrailingZeros(pageSize);
        this.pageMask = pageSize - 1;
        this.size = 0L;
    }

    final int numPages(long capacity) {
        long numPages = capacity + (long)this.pageMask >>> this.pageShift;
        if (numPages > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("pageSize=" + (this.pageMask + 1) + " is too small for such as capacity: " + capacity);
        }
        return (int)numPages;
    }

    final int pageSize() {
        return this.pageMask + 1;
    }

    final int pageIndex(long index) {
        return (int)(index >>> this.pageShift);
    }

    final int indexInPage(long index) {
        return (int)(index & (long)this.pageMask);
    }

    @Override
    public final long size() {
        return this.size;
    }

    public abstract void resize(long var1);

    protected abstract int numBytesPerElement();

    public final long ramBytesUsed() {
        return ((long)this.pageIndex(this.size - 1L) + 1L) * (long)this.pageSize() * (long)this.numBytesPerElement();
    }

    protected final byte[] newBytePage(int page) {
        if (this.recycler != null) {
            throw new UnsupportedOperationException("querybuilders does not support this operation.");
        }
        return new byte[16384];
    }

    protected final int[] newIntPage(int page) {
        if (this.recycler != null) {
            throw new UnsupportedOperationException("querybuilders does not support this operation.");
        }
        return new int[4096];
    }

    protected final long[] newLongPage(int page) {
        if (this.recycler != null) {
            throw new UnsupportedOperationException("querybuilders does not support this operation.");
        }
        return new long[2048];
    }

    protected final Object[] newObjectPage(int page) {
        if (this.recycler != null) {
            throw new UnsupportedOperationException("querybuilders does not support this operation.");
        }
        return new Object[BigArrays.OBJECT_PAGE_SIZE];
    }

    protected final void releasePage(int page) {
        if (this.recycler != null) {
            throw new UnsupportedOperationException("querybuilders does not support this operation.");
        }
    }

    @Override
    protected final void doClose() {
        if (this.recycler != null) {
            throw new UnsupportedOperationException("querybuilders does not support this operation.");
        }
    }
}

