/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.unit;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.codelibs.elasticsearch.common.ParseField;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;

public final class Fuzziness
implements ToXContent,
Writeable {
    public static final String X_FIELD_NAME = "fuzziness";
    public static final Fuzziness ZERO = new Fuzziness(0);
    public static final Fuzziness ONE = new Fuzziness(1);
    public static final Fuzziness TWO = new Fuzziness(2);
    public static final Fuzziness AUTO = new Fuzziness("AUTO");
    public static final ParseField FIELD = new ParseField("fuzziness", new String[0]);
    private final String fuzziness;

    private Fuzziness(int fuzziness) {
        if (fuzziness != 0 && fuzziness != 1 && fuzziness != 2) {
            throw new IllegalArgumentException("Valid edit distances are [0, 1, 2] but was [" + fuzziness + "]");
        }
        this.fuzziness = Integer.toString(fuzziness);
    }

    private Fuzziness(String fuzziness) {
        if (fuzziness == null) {
            throw new IllegalArgumentException("fuzziness can't be null!");
        }
        this.fuzziness = fuzziness.toUpperCase(Locale.ROOT);
    }

    public Fuzziness(StreamInput in) throws IOException {
        this.fuzziness = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fuzziness);
    }

    public static Fuzziness fromEdits(int edits) {
        return new Fuzziness(edits);
    }

    public static Fuzziness build(Object fuzziness) {
        if (fuzziness instanceof Fuzziness) {
            return (Fuzziness)fuzziness;
        }
        String string = fuzziness.toString();
        if (AUTO.asString().equalsIgnoreCase(string)) {
            return AUTO;
        }
        return new Fuzziness(string);
    }

    public static Fuzziness parse(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        switch (token) {
            case VALUE_STRING: 
            case VALUE_NUMBER: {
                String fuzziness = parser.text();
                if (AUTO.asString().equalsIgnoreCase(fuzziness)) {
                    return AUTO;
                }
                try {
                    int minimumSimilarity = Integer.parseInt(fuzziness);
                    switch (minimumSimilarity) {
                        case 0: {
                            return ZERO;
                        }
                        case 1: {
                            return ONE;
                        }
                        case 2: {
                            return TWO;
                        }
                    }
                    return Fuzziness.build(fuzziness);
                }
                catch (NumberFormatException ex) {
                    return Fuzziness.build(fuzziness);
                }
            }
        }
        throw new IllegalArgumentException("Can't parse fuzziness on token: [" + (Object)((Object)token) + "]");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, true);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean includeFieldName) throws IOException {
        if (includeFieldName) {
            builder.field(X_FIELD_NAME, this.fuzziness);
        } else {
            builder.value(this.fuzziness);
        }
        return builder;
    }

    public int asDistance() {
        return this.asDistance(null);
    }

    public int asDistance(String text) {
        if (this.equals(AUTO)) {
            int len = this.termLen(text);
            if (len <= 2) {
                return 0;
            }
            if (len > 5) {
                return 2;
            }
            return 1;
        }
        return Math.min(2, (int)this.asFloat());
    }

    public float asFloat() {
        if (this.equals(AUTO)) {
            return 1.0f;
        }
        return Float.parseFloat(this.fuzziness.toString());
    }

    private int termLen(String text) {
        return text == null ? 5 : text.codePointCount(0, text.length());
    }

    public String asString() {
        return this.fuzziness.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Fuzziness other = (Fuzziness)obj;
        return Objects.equals(this.fuzziness, other.fuzziness);
    }

    public int hashCode() {
        return this.fuzziness.hashCode();
    }
}

