/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.settings.loader;

import org.codelibs.elasticsearch.common.settings.loader.JsonSettingsLoader;
import org.codelibs.elasticsearch.common.settings.loader.SettingsLoader;
import org.codelibs.elasticsearch.common.settings.loader.YamlSettingsLoader;

public final class SettingsLoaderFactory {
    private SettingsLoaderFactory() {
    }

    public static SettingsLoader loaderFromResource(String resourceName) {
        if (resourceName.endsWith(".json")) {
            return new JsonSettingsLoader(false);
        }
        if (resourceName.endsWith(".yml") || resourceName.endsWith(".yaml")) {
            return new YamlSettingsLoader(false);
        }
        throw new IllegalArgumentException("unable to detect content type from resource name [" + resourceName + "]");
    }

    public static SettingsLoader loaderFromSource(String source) {
        if (source.indexOf(123) != -1 && source.indexOf(125) != -1) {
            return new JsonSettingsLoader(true);
        }
        if (source.indexOf(58) != -1) {
            return new YamlSettingsLoader(true);
        }
        throw new IllegalArgumentException("unable to detect content type from source [" + source + "]");
    }
}

