/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.rounding;

import java.io.IOException;
import java.util.Objects;
import org.codelibs.elasticsearch.ElasticsearchException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Streamable;
import org.codelibs.elasticsearch.common.rounding.DateTimeUnit;
import org.codelibs.elasticsearch.common.unit.TimeValue;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;

public abstract class Rounding
implements Streamable {
    public abstract byte id();

    public abstract long round(long var1);

    public abstract long nextRoundingValue(long var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static Builder builder(DateTimeUnit unit) {
        return new Builder(unit);
    }

    public static Builder builder(TimeValue interval) {
        return new Builder(interval);
    }

    public static class Streams {
        public static void write(Rounding rounding, StreamOutput out) throws IOException {
            out.writeByte(rounding.id());
            rounding.writeTo(out);
        }

        public static Rounding read(StreamInput in) throws IOException {
            Rounding rounding = null;
            byte id = in.readByte();
            switch (id) {
                case 1: {
                    rounding = new TimeUnitRounding();
                    break;
                }
                case 2: {
                    rounding = new TimeIntervalRounding();
                    break;
                }
                default: {
                    throw new ElasticsearchException("unknown rounding id [" + id + "]", new Object[0]);
                }
            }
            rounding.readFrom(in);
            return rounding;
        }
    }

    static class TimeIntervalRounding
    extends Rounding {
        static final byte ID = 2;
        private long interval;
        private DateTimeZone timeZone;

        TimeIntervalRounding() {
        }

        TimeIntervalRounding(long interval, DateTimeZone timeZone) {
            if (interval < 1L) {
                throw new IllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval;
            this.timeZone = timeZone;
        }

        @Override
        public byte id() {
            return 2;
        }

        @Override
        public long round(long utcMillis) {
            long roundedUTC;
            long timeLocal = this.timeZone.convertUTCToLocal(utcMillis);
            long rounded = TimeIntervalRounding.roundKey(timeLocal, this.interval) * this.interval;
            if (!this.isInDSTGap(rounded)) {
                roundedUTC = this.timeZone.convertLocalToUTC(rounded, true, utcMillis);
                long transition = this.timeZone.previousTransition(utcMillis);
                if (transition != utcMillis && transition > roundedUTC) {
                    roundedUTC = this.round(transition - 1L);
                }
            } else {
                roundedUTC = this.timeZone.previousTransition(utcMillis) + 1L;
            }
            return roundedUTC;
        }

        private static long roundKey(long value, long interval) {
            if (value < 0L) {
                return (value - interval + 1L) / interval;
            }
            return value / interval;
        }

        private boolean isInDSTGap(long instantLocal) {
            int offset;
            if (this.timeZone.isFixed()) {
                return false;
            }
            int offsetLocal = this.timeZone.getOffset(instantLocal);
            if (offsetLocal != (offset = this.timeZone.getOffset(instantLocal - (long)offsetLocal))) {
                long nextAdjusted;
                long nextLocal = this.timeZone.nextTransition(instantLocal - (long)offsetLocal);
                if (nextLocal == instantLocal - (long)offsetLocal) {
                    nextLocal = Long.MAX_VALUE;
                }
                if ((nextAdjusted = this.timeZone.nextTransition(instantLocal - (long)offset)) == instantLocal - (long)offset) {
                    nextAdjusted = Long.MAX_VALUE;
                }
                if (nextLocal != nextAdjusted) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public long nextRoundingValue(long time) {
            long timeLocal = time;
            timeLocal = this.timeZone.convertUTCToLocal(time);
            long next = timeLocal + this.interval;
            return this.timeZone.convertLocalToUTC(next, false);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.interval = in.readVLong();
            this.timeZone = DateTimeZone.forID((String)in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
            out.writeString(this.timeZone.getID());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.interval, this.timeZone);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeIntervalRounding other = (TimeIntervalRounding)obj;
            return Objects.equals(this.interval, other.interval) && Objects.equals(this.timeZone, other.timeZone);
        }
    }

    static class TimeUnitRounding
    extends Rounding {
        static final byte ID = 1;
        private DateTimeUnit unit;
        private DateTimeField field;
        private DateTimeZone timeZone;

        TimeUnitRounding() {
        }

        TimeUnitRounding(DateTimeUnit unit, DateTimeZone timeZone) {
            this.unit = unit;
            this.field = unit.field(timeZone);
            this.timeZone = timeZone;
        }

        @Override
        public byte id() {
            return 1;
        }

        @Override
        public long round(long utcMillis) {
            long rounded = this.field.roundFloor(utcMillis);
            if (!this.timeZone.isFixed()) {
                long previousRounded;
                if (this.timeZone.getOffset(utcMillis) != this.timeZone.getOffset(rounded)) {
                    rounded = this.field.roundFloor(rounded);
                } else if (this.timeZone.getOffset(rounded) < this.timeZone.getOffset(rounded - 1L) && rounded - (previousRounded = this.field.roundFloor(rounded - 1L)) < this.field.getDurationField().getUnitMillis()) {
                    rounded = previousRounded;
                }
            }
            assert (rounded == this.field.roundFloor(rounded));
            return rounded;
        }

        @Override
        public long nextRoundingValue(long utcMillis) {
            long floor = this.round(utcMillis);
            long next = this.round(this.field.add(floor, 1));
            if (next == floor) {
                next = this.round(this.field.add(floor, 2));
            }
            return next;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.unit = DateTimeUnit.resolve(in.readByte());
            this.timeZone = DateTimeZone.forID((String)in.readString());
            this.field = this.unit.field(this.timeZone);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.unit.id());
            out.writeString(this.timeZone.getID());
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.unit, this.timeZone});
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeUnitRounding other = (TimeUnitRounding)obj;
            return Objects.equals((Object)this.unit, (Object)other.unit) && Objects.equals(this.timeZone, other.timeZone);
        }

        public String toString() {
            return "[" + this.timeZone + "][" + (Object)((Object)this.unit) + "]";
        }
    }

    public static class Builder {
        private final DateTimeUnit unit;
        private final long interval;
        private DateTimeZone timeZone = DateTimeZone.UTC;

        public Builder(DateTimeUnit unit) {
            this.unit = unit;
            this.interval = -1L;
        }

        public Builder(TimeValue interval) {
            this.unit = null;
            if (interval.millis() < 1L) {
                throw new IllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval.millis();
        }

        public Builder timeZone(DateTimeZone timeZone) {
            if (timeZone == null) {
                throw new IllegalArgumentException("Setting null as timezone is not supported");
            }
            this.timeZone = timeZone;
            return this;
        }

        public Rounding build() {
            Rounding timeZoneRounding = this.unit != null ? new TimeUnitRounding(this.unit, this.timeZone) : new TimeIntervalRounding(this.interval, this.timeZone);
            return timeZoneRounding;
        }
    }
}

