/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.lucene.uid;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.codelibs.elasticsearch.common.lucene.uid.Versions;

final class PerThreadIDAndVersionLookup {
    private final TermsEnum termsEnum;
    private final NumericDocValues versions;
    private PostingsEnum docsEnum;

    public PerThreadIDAndVersionLookup(LeafReader reader) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public Versions.DocIdAndVersion lookup(BytesRef id, Bits liveDocs, LeafReaderContext context) throws IOException {
        if (this.termsEnum.seekExact(id)) {
            this.docsEnum = this.termsEnum.postings(this.docsEnum, 0);
            int docID = Integer.MAX_VALUE;
            int d = this.docsEnum.nextDoc();
            while (d != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(d)) {
                    docID = d;
                }
                d = this.docsEnum.nextDoc();
            }
            if (docID != Integer.MAX_VALUE) {
                return new Versions.DocIdAndVersion(docID, this.versions.get(docID), context);
            }
        }
        return null;
    }
}

