/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.codelibs.elasticsearch.common.lucene.search.function.CombineFunction;
import org.codelibs.elasticsearch.common.lucene.search.function.LeafScoreFunction;

public abstract class ScoreFunction {
    private final CombineFunction scoreCombiner;

    protected ScoreFunction(CombineFunction scoreCombiner) {
        this.scoreCombiner = scoreCombiner;
    }

    public CombineFunction getDefaultScoreCombiner() {
        return this.scoreCombiner;
    }

    public abstract LeafScoreFunction getLeafScoreFunction(LeafReaderContext var1) throws IOException;

    public abstract boolean needsScores();

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScoreFunction other = (ScoreFunction)obj;
        return Objects.equals(this.scoreCombiner, other.scoreCombiner) && this.doEquals(other);
    }

    protected abstract boolean doEquals(ScoreFunction var1);

    public final int hashCode() {
        return Objects.hash(this.scoreCombiner, this.doHashCode());
    }

    protected abstract int doHashCode();
}

