/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.codelibs.elasticsearch.common.lucene.search.function.CombineFunction;
import org.codelibs.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.codelibs.elasticsearch.common.lucene.search.function.MinScoreScorer;
import org.codelibs.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FunctionScoreQuery
extends Query {
    public static final float DEFAULT_MAX_BOOST = Float.MAX_VALUE;
    final Query subQuery;
    final ScoreFunction function;
    final float maxBoost;
    final CombineFunction combineFunction;
    private Float minScore;

    public FunctionScoreQuery(Query subQuery, ScoreFunction function, Float minScore, CombineFunction combineFunction, float maxBoost) {
        this.subQuery = subQuery;
        this.function = function;
        this.combineFunction = combineFunction;
        this.minScore = minScore;
        this.maxBoost = maxBoost;
    }

    public FunctionScoreQuery(Query subQuery, ScoreFunction function) {
        this.subQuery = subQuery;
        this.function = function;
        this.combineFunction = function.getDefaultScoreCombiner();
        this.maxBoost = Float.MAX_VALUE;
    }

    public float getMaxBoost() {
        return this.maxBoost;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public ScoreFunction getFunction() {
        return this.function;
    }

    public Float getMinScore() {
        return this.minScore;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = super.rewrite(reader);
        if (rewritten != this) {
            return rewritten;
        }
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        return new FunctionScoreQuery(newQ, this.function, this.minScore, this.combineFunction, this.maxBoost);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (!needsScores && this.minScore == null) {
            return this.subQuery.createWeight(searcher, needsScores);
        }
        boolean subQueryNeedsScores = this.combineFunction != CombineFunction.REPLACE || this.function == null || this.function.needsScores();
        Weight subQueryWeight = this.subQuery.createWeight(searcher, subQueryNeedsScores);
        return new CustomBoostFactorWeight(this, subQueryWeight, subQueryNeedsScores);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("function score (").append(this.subQuery.toString(field)).append(",function=").append(this.function).append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        FunctionScoreQuery other = (FunctionScoreQuery)((Object)o);
        return Objects.equals(this.subQuery, other.subQuery) && Objects.equals(this.function, other.function) && Objects.equals(this.combineFunction, other.combineFunction) && Objects.equals(this.minScore, other.minScore) && this.maxBoost == other.maxBoost;
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.subQuery.hashCode(), this.function, this.combineFunction, this.minScore, Float.valueOf(this.maxBoost));
    }

    static class FunctionFactorScorer
    extends FilterScorer {
        private final LeafScoreFunction function;
        private final boolean needsScores;
        private final CombineFunction scoreCombiner;
        private final float maxBoost;

        private FunctionFactorScorer(CustomBoostFactorWeight w, Scorer scorer, LeafScoreFunction function, float maxBoost, CombineFunction scoreCombiner, boolean needsScores) throws IOException {
            super(scorer, (Weight)w);
            this.function = function;
            this.scoreCombiner = scoreCombiner;
            this.maxBoost = maxBoost;
            this.needsScores = needsScores;
        }

        public float score() throws IOException {
            float score;
            float f = score = this.needsScores ? super.score() : 0.0f;
            if (this.function == null) {
                return score;
            }
            return this.scoreCombiner.combine(score, this.function.score(this.docID(), score), this.maxBoost);
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        final Weight subQueryWeight;
        final boolean needsScores;

        public CustomBoostFactorWeight(Query parent, Weight subQueryWeight, boolean needsScores) throws IOException {
            super(parent);
            this.subQueryWeight = subQueryWeight;
            this.needsScores = needsScores;
        }

        public void extractTerms(Set<Term> terms) {
            this.subQueryWeight.extractTerms(terms);
        }

        public float getValueForNormalization() throws IOException {
            return this.subQueryWeight.getValueForNormalization();
        }

        public void normalize(float norm, float boost) {
            this.subQueryWeight.normalize(norm, boost);
        }

        private FunctionFactorScorer functionScorer(LeafReaderContext context) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context);
            if (subQueryScorer == null) {
                return null;
            }
            LeafScoreFunction leafFunction = null;
            if (FunctionScoreQuery.this.function != null) {
                leafFunction = FunctionScoreQuery.this.function.getLeafScoreFunction(context);
            }
            return new FunctionFactorScorer(this, subQueryScorer, leafFunction, FunctionScoreQuery.this.maxBoost, FunctionScoreQuery.this.combineFunction, this.needsScores);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Object scorer = this.functionScorer(context);
            if (scorer != null && FunctionScoreQuery.this.minScore != null) {
                scorer = new MinScoreScorer(this, (Scorer)scorer, FunctionScoreQuery.this.minScore.floatValue());
            }
            return scorer;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Explanation expl;
            Explanation subQueryExpl = this.subQueryWeight.explain(context, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            if (FunctionScoreQuery.this.function != null) {
                Explanation functionExplanation = FunctionScoreQuery.this.function.getLeafScoreFunction(context).explainScore(doc, subQueryExpl);
                expl = FunctionScoreQuery.this.combineFunction.explain(subQueryExpl, functionExplanation, FunctionScoreQuery.this.maxBoost);
            } else {
                expl = subQueryExpl;
            }
            if (FunctionScoreQuery.this.minScore != null && FunctionScoreQuery.this.minScore.floatValue() > expl.getValue()) {
                expl = Explanation.noMatch((String)("Score value is too low, expected at least " + FunctionScoreQuery.this.minScore + " but got " + expl.getValue()), (Explanation[])new Explanation[]{expl});
            }
            return expl;
        }
    }
}

