/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.lucene.Lucene;
import org.codelibs.elasticsearch.common.lucene.search.function.CombineFunction;
import org.codelibs.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.codelibs.elasticsearch.common.lucene.search.function.MinScoreScorer;
import org.codelibs.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.codelibs.elasticsearch.common.lucene.search.function.WeightFactorFunction;

public class FiltersFunctionScoreQuery
extends Query {
    final Query subQuery;
    final FilterFunction[] filterFunctions;
    final ScoreMode scoreMode;
    final float maxBoost;
    private final Float minScore;
    protected final CombineFunction combineFunction;

    public FiltersFunctionScoreQuery(Query subQuery, ScoreMode scoreMode, FilterFunction[] filterFunctions, float maxBoost, Float minScore, CombineFunction combineFunction) {
        this.subQuery = subQuery;
        this.scoreMode = scoreMode;
        this.filterFunctions = filterFunctions;
        this.maxBoost = maxBoost;
        this.combineFunction = combineFunction;
        this.minScore = minScore;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public FilterFunction[] getFilterFunctions() {
        return this.filterFunctions;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = super.rewrite(reader);
        if (rewritten != this) {
            return rewritten;
        }
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        return new FiltersFunctionScoreQuery(newQ, this.scoreMode, this.filterFunctions, this.maxBoost, this.minScore, this.combineFunction);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (!needsScores && this.minScore == null) {
            return this.subQuery.createWeight(searcher, needsScores);
        }
        boolean subQueryNeedsScores = this.combineFunction != CombineFunction.REPLACE;
        Weight[] filterWeights = new Weight[this.filterFunctions.length];
        for (int i = 0; i < this.filterFunctions.length; ++i) {
            subQueryNeedsScores |= this.filterFunctions[i].function.needsScores();
            filterWeights[i] = searcher.createNormalizedWeight(this.filterFunctions[i].filter, false);
        }
        Weight subQueryWeight = this.subQuery.createWeight(searcher, subQueryNeedsScores);
        return new CustomBoostFactorWeight(this, subQueryWeight, filterWeights, subQueryNeedsScores);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("function score (").append(this.subQuery.toString(field)).append(", functions: [");
        for (FilterFunction filterFunction : this.filterFunctions) {
            sb.append("{filter(").append(filterFunction.filter).append("), function [").append(filterFunction.function).append("]}");
        }
        sb.append("])");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        FiltersFunctionScoreQuery other = (FiltersFunctionScoreQuery)((Object)o);
        return Objects.equals(this.subQuery, other.subQuery) && this.maxBoost == other.maxBoost && Objects.equals(this.combineFunction, other.combineFunction) && Objects.equals(this.minScore, other.minScore) && Objects.equals(this.scoreMode, other.scoreMode) && Arrays.equals(this.filterFunctions, other.filterFunctions);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.subQuery, Float.valueOf(this.maxBoost), this.combineFunction, this.minScore, this.scoreMode, Arrays.hashCode(this.filterFunctions));
    }

    static class FiltersFunctionFactorScorer
    extends FilterScorer {
        private final FilterFunction[] filterFunctions;
        private final ScoreMode scoreMode;
        private final LeafScoreFunction[] functions;
        private final Bits[] docSets;
        private final CombineFunction scoreCombiner;
        private final float maxBoost;
        private final boolean needsScores;

        private FiltersFunctionFactorScorer(CustomBoostFactorWeight w, Scorer scorer, ScoreMode scoreMode, FilterFunction[] filterFunctions, float maxBoost, LeafScoreFunction[] functions, Bits[] docSets, CombineFunction scoreCombiner, boolean needsScores) throws IOException {
            super(scorer, (Weight)w);
            this.scoreMode = scoreMode;
            this.filterFunctions = filterFunctions;
            this.functions = functions;
            this.docSets = docSets;
            this.scoreCombiner = scoreCombiner;
            this.maxBoost = maxBoost;
            this.needsScores = needsScores;
        }

        public float score() throws IOException {
            int docId = this.docID();
            float subQueryScore = this.needsScores ? super.score() : 0.0f;
            double factor = this.computeScore(docId, subQueryScore);
            return this.scoreCombiner.combine(subQueryScore, factor, this.maxBoost);
        }

        protected double computeScore(int docId, float subQueryScore) {
            double factor = 1.0;
            block0 : switch (this.scoreMode) {
                case FIRST: {
                    for (int i = 0; i < this.filterFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        factor = this.functions[i].score(docId, subQueryScore);
                        break block0;
                    }
                    break;
                }
                case MAX: {
                    double maxFactor = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < this.filterFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        maxFactor = Math.max(this.functions[i].score(docId, subQueryScore), maxFactor);
                    }
                    if (maxFactor == Double.NEGATIVE_INFINITY) break;
                    factor = maxFactor;
                    break;
                }
                case MIN: {
                    double minFactor = Double.POSITIVE_INFINITY;
                    for (int i = 0; i < this.filterFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        minFactor = Math.min(this.functions[i].score(docId, subQueryScore), minFactor);
                    }
                    if (minFactor == Double.POSITIVE_INFINITY) break;
                    factor = minFactor;
                    break;
                }
                case MULTIPLY: {
                    for (int i = 0; i < this.filterFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        factor *= this.functions[i].score(docId, subQueryScore);
                    }
                    break;
                }
                default: {
                    double totalFactor = 0.0;
                    double weightSum = 0.0;
                    for (int i = 0; i < this.filterFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        totalFactor += this.functions[i].score(docId, subQueryScore);
                        if (this.filterFunctions[i].function instanceof WeightFactorFunction) {
                            weightSum += (double)((WeightFactorFunction)this.filterFunctions[i].function).getWeight();
                            continue;
                        }
                        weightSum += 1.0;
                    }
                    if (weightSum == 0.0) break;
                    factor = totalFactor;
                    if (this.scoreMode != ScoreMode.AVG) break;
                    factor /= weightSum;
                }
            }
            return factor;
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        final Weight subQueryWeight;
        final Weight[] filterWeights;
        final boolean needsScores;

        public CustomBoostFactorWeight(Query parent, Weight subQueryWeight, Weight[] filterWeights, boolean needsScores) throws IOException {
            super(parent);
            this.subQueryWeight = subQueryWeight;
            this.filterWeights = filterWeights;
            this.needsScores = needsScores;
        }

        public void extractTerms(Set<Term> terms) {
            this.subQueryWeight.extractTerms(terms);
        }

        public float getValueForNormalization() throws IOException {
            return this.subQueryWeight.getValueForNormalization();
        }

        public void normalize(float norm, float boost) {
            this.subQueryWeight.normalize(norm, boost);
        }

        private FiltersFunctionFactorScorer functionScorer(LeafReaderContext context) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context);
            if (subQueryScorer == null) {
                return null;
            }
            LeafScoreFunction[] functions = new LeafScoreFunction[FiltersFunctionScoreQuery.this.filterFunctions.length];
            Bits[] docSets = new Bits[FiltersFunctionScoreQuery.this.filterFunctions.length];
            for (int i = 0; i < FiltersFunctionScoreQuery.this.filterFunctions.length; ++i) {
                FilterFunction filterFunction = FiltersFunctionScoreQuery.this.filterFunctions[i];
                functions[i] = filterFunction.function.getLeafScoreFunction(context);
                Scorer filterScorer = this.filterWeights[i].scorer(context);
                docSets[i] = Lucene.asSequentialAccessBits(context.reader().maxDoc(), filterScorer);
            }
            return new FiltersFunctionFactorScorer(this, subQueryScorer, FiltersFunctionScoreQuery.this.scoreMode, FiltersFunctionScoreQuery.this.filterFunctions, FiltersFunctionScoreQuery.this.maxBoost, functions, docSets, FiltersFunctionScoreQuery.this.combineFunction, this.needsScores);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Object scorer = this.functionScorer(context);
            if (scorer != null && FiltersFunctionScoreQuery.this.minScore != null) {
                scorer = new MinScoreScorer(this, (Scorer)scorer, FiltersFunctionScoreQuery.this.minScore.floatValue());
            }
            return scorer;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Explanation expl = this.subQueryWeight.explain(context, doc);
            if (!expl.isMatch()) {
                return expl;
            }
            ArrayList<Explanation> filterExplanations = new ArrayList<Explanation>();
            for (int i = 0; i < FiltersFunctionScoreQuery.this.filterFunctions.length; ++i) {
                Bits docSet = Lucene.asSequentialAccessBits(context.reader().maxDoc(), this.filterWeights[i].scorer(context));
                if (!docSet.get(doc)) continue;
                FilterFunction filterFunction = FiltersFunctionScoreQuery.this.filterFunctions[i];
                Explanation functionExplanation = filterFunction.function.getLeafScoreFunction(context).explainScore(doc, expl);
                double factor = functionExplanation.getValue();
                float sc = CombineFunction.toFloat(factor);
                Explanation filterExplanation = Explanation.match((float)sc, (String)"function score, product of:", (Explanation[])new Explanation[]{Explanation.match((float)1.0f, (String)("match filter: " + filterFunction.filter.toString()), (Explanation[])new Explanation[0]), functionExplanation});
                filterExplanations.add(filterExplanation);
            }
            FiltersFunctionFactorScorer scorer = this.functionScorer(context);
            int actualDoc = scorer.iterator().advance(doc);
            assert (actualDoc == doc);
            double score = scorer.computeScore(doc, expl.getValue());
            Explanation factorExplanation = filterExplanations.size() > 0 ? Explanation.match((float)CombineFunction.toFloat(score), (String)("function score, score mode [" + FiltersFunctionScoreQuery.this.scoreMode.toString().toLowerCase(Locale.ROOT) + "]"), filterExplanations) : Explanation.match((float)1.0f, (String)"No function matched", Collections.emptyList());
            expl = FiltersFunctionScoreQuery.this.combineFunction.explain(expl, factorExplanation, FiltersFunctionScoreQuery.this.maxBoost);
            if (FiltersFunctionScoreQuery.this.minScore != null && FiltersFunctionScoreQuery.this.minScore.floatValue() > expl.getValue()) {
                expl = Explanation.noMatch((String)("Score value is too low, expected at least " + FiltersFunctionScoreQuery.this.minScore + " but got " + expl.getValue()), (Explanation[])new Explanation[]{expl});
            }
            return expl;
        }
    }

    public static enum ScoreMode implements Writeable
    {
        FIRST,
        AVG,
        MAX,
        SUM,
        MIN,
        MULTIPLY;


        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }

        public static ScoreMode readFromStream(StreamInput in) throws IOException {
            int ordinal = in.readVInt();
            if (ordinal < 0 || ordinal >= ScoreMode.values().length) {
                throw new IOException("Unknown ScoreMode ordinal [" + ordinal + "]");
            }
            return ScoreMode.values()[ordinal];
        }

        public static ScoreMode fromString(String scoreMode) {
            return ScoreMode.valueOf(scoreMode.toUpperCase(Locale.ROOT));
        }
    }

    public static class FilterFunction {
        public final Query filter;
        public final ScoreFunction function;

        public FilterFunction(Query filter, ScoreFunction function) {
            this.filter = filter;
            this.function = function;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterFunction that = (FilterFunction)o;
            return Objects.equals(this.filter, that.filter) && Objects.equals(this.function, that.function);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.filter, this.function);
        }
    }
}

