/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;

public class MultiPhrasePrefixQuery
extends Query {
    private String field;
    private ArrayList<Term[]> termArrays = new ArrayList();
    private ArrayList<Integer> positions = new ArrayList();
    private int slop = 0;

    public void setSlop(int s) {
        this.slop = s;
    }

    public void setMaxExpansions(int maxExpansions) {
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        this.add(new Term[]{term});
    }

    public void add(Term[] terms) {
        int position = 0;
        if (this.positions.size() > 0) {
            position = this.positions.get(this.positions.size() - 1) + 1;
        }
        this.add(terms, position);
    }

    public void add(Term[] terms, int position) {
        if (this.termArrays.size() == 0) {
            this.field = terms[0].field();
        }
        for (Term term : terms) {
            if (term.field() == this.field) continue;
            throw new IllegalArgumentException("All phrase terms must be in the same field (" + this.field + "): " + term);
        }
        this.termArrays.add(terms);
        this.positions.add(position);
    }

    public int[] getPositions() {
        int[] result = new int[this.positions.size()];
        for (int i = 0; i < this.positions.size(); ++i) {
            result[i] = this.positions.get(i);
        }
        return result;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public final String toString(String f) {
        StringBuilder buffer = new StringBuilder();
        if (this.field == null || !this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        Iterator<Term[]> i = this.termArrays.iterator();
        while (i.hasNext()) {
            Term[] terms = i.next();
            if (terms.length > 1) {
                buffer.append("(");
                for (int j = 0; j < terms.length; ++j) {
                    buffer.append(terms[j].text());
                    if (j >= terms.length - 1) continue;
                    if (i.hasNext()) {
                        buffer.append(" ");
                        continue;
                    }
                    buffer.append("* ");
                }
                if (i.hasNext()) {
                    buffer.append(") ");
                    continue;
                }
                buffer.append("*)");
                continue;
            }
            buffer.append(terms[0].text());
            if (i.hasNext()) {
                buffer.append(" ");
                continue;
            }
            buffer.append("*");
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!this.sameClassAs(o)) {
            return false;
        }
        MultiPhrasePrefixQuery other = (MultiPhrasePrefixQuery)((Object)o);
        return this.slop == other.slop && this.termArraysEquals(this.termArrays, other.termArrays) && this.positions.equals(other.positions);
    }

    public int hashCode() {
        return this.classHash() ^ this.slop ^ this.termArraysHashCode() ^ this.positions.hashCode();
    }

    private int termArraysHashCode() {
        int hashCode = 1;
        for (Object[] objectArray : this.termArrays) {
            hashCode = 31 * hashCode + (objectArray == null ? 0 : Arrays.hashCode(objectArray));
        }
        return hashCode;
    }

    private boolean termArraysEquals(List<Term[]> termArrays1, List<Term[]> termArrays2) {
        if (termArrays1.size() != termArrays2.size()) {
            return false;
        }
        ListIterator<Term[]> iterator1 = termArrays1.listIterator();
        ListIterator<Term[]> iterator2 = termArrays2.listIterator();
        while (iterator1.hasNext()) {
            Object[] termArray1 = iterator1.next();
            Object[] termArray2 = iterator2.next();
            if (termArray1 != null ? Arrays.equals(termArray1, termArray2) : termArray2 == null) continue;
            return false;
        }
        return true;
    }

    public String getField() {
        return this.field;
    }
}

