/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.lucene;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;

public class MinimumScoreCollector
extends SimpleCollector {
    private final Collector collector;
    private final float minimumScore;
    private Scorer scorer;
    private LeafCollector leafCollector;

    public MinimumScoreCollector(Collector collector, float minimumScore) {
        this.collector = collector;
        this.minimumScore = minimumScore;
    }

    public void setScorer(Scorer scorer) throws IOException {
        if (!(scorer instanceof ScoreCachingWrappingScorer)) {
            scorer = new ScoreCachingWrappingScorer(scorer);
        }
        this.scorer = scorer;
        this.leafCollector.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        if (this.scorer.score() >= this.minimumScore) {
            this.leafCollector.collect(doc);
        }
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.leafCollector = this.collector.getLeafCollector(context);
    }

    public boolean needsScores() {
        return true;
    }
}

