/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.lucene;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.util.InfoStream;
import org.codelibs.elasticsearch.common.logging.Loggers;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.Logger;

public final class LoggerInfoStream
extends InfoStream {
    private final Logger parentLogger;
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();

    public LoggerInfoStream(Logger parentLogger) {
        this.parentLogger = parentLogger;
    }

    public void message(String component, String message) {
        this.getLogger(component).trace("{} {}: {}", (Object)Thread.currentThread().getName(), (Object)component, (Object)message);
    }

    public boolean isEnabled(String component) {
        return this.getLogger(component).isTraceEnabled() && !component.equals("TP");
    }

    private Logger getLogger(String component) {
        return this.loggers.computeIfAbsent(component, c -> Loggers.getLogger(this.parentLogger, "." + c));
    }

    public void close() {
    }
}

