/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.logging;

import java.util.Map;
import org.codelibs.elasticsearch.common.logging.ESLoggerFactory;
import org.codelibs.elasticsearch.common.logging.PrefixLogger;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.Level;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.LogManager;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.Logger;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.core.Appender;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.core.LoggerContext;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.core.config.Configuration;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.core.config.Configurator;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.core.config.LoggerConfig;

public class Loggers {
    public static final String SPACE = " ";

    public static Logger getLogger(Class<?> clazz, Settings settings, String ... prefixes) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public static Logger getLogger(String loggerName, Settings settings, String ... prefixes) {
        throw new UnsupportedOperationException("querybuilders does not support this operation.");
    }

    public static Logger getLogger(Logger parentLogger, String s) {
        assert (parentLogger instanceof PrefixLogger);
        return ESLoggerFactory.getLogger(((PrefixLogger)parentLogger).prefix(), parentLogger.getName() + s);
    }

    public static Logger getLogger(String s) {
        return ESLoggerFactory.getLogger(s);
    }

    public static Logger getLogger(Class<?> clazz) {
        return ESLoggerFactory.getLogger(clazz);
    }

    public static Logger getLogger(Class<?> clazz, String ... prefixes) {
        return ESLoggerFactory.getLogger(Loggers.formatPrefix(prefixes), clazz);
    }

    public static Logger getLogger(String name, String ... prefixes) {
        return ESLoggerFactory.getLogger(Loggers.formatPrefix(prefixes), name);
    }

    private static String formatPrefix(String ... prefixes) {
        String prefix = null;
        if (prefixes != null && prefixes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String prefixX : prefixes) {
                if (prefixX == null) continue;
                if (prefixX.equals(SPACE)) {
                    sb.append(SPACE);
                    continue;
                }
                sb.append("[").append(prefixX).append("]");
            }
            if (sb.length() > 0) {
                sb.append(SPACE);
                prefix = sb.toString();
            }
        }
        return prefix;
    }

    public static void setLevel(Logger logger, String level) {
        Level l = level == null ? null : Level.valueOf(level);
        Loggers.setLevel(logger, l);
    }

    public static void setLevel(Logger logger, Level level) {
        LoggerContext ctx;
        if (!"".equals(logger.getName())) {
            Configurator.setLevel(logger.getName(), level);
        } else {
            ctx = LoggerContext.getContext(false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
            loggerConfig.setLevel(level);
            ctx.updateLoggers();
        }
        ctx = LoggerContext.getContext(false);
        for (LoggerConfig loggerConfig : ctx.getConfiguration().getLoggers().values()) {
            if (!"".equals(logger.getName()) && !loggerConfig.getName().startsWith(logger.getName() + ".")) continue;
            Configurator.setLevel(loggerConfig.getName(), level);
        }
    }

    public static void addAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        config.addAppender(appender);
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.addAppender(appender, null, null);
        ctx.updateLoggers();
    }

    public static void removeAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.removeAppender(appender.getName());
        ctx.updateLoggers();
    }

    public static Appender findAppender(Logger logger, Class<? extends Appender> clazz) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        for (Map.Entry<String, Appender> entry : loggerConfig.getAppenders().entrySet()) {
            if (!entry.getValue().getClass().equals(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }
}

