/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.logging;

import java.util.Map;
import java.util.Objects;
import org.codelibs.elasticsearch.common.logging.ESLoggerFactory;
import org.codelibs.elasticsearch.common.logging.Loggers;
import org.codelibs.elasticsearch.common.settings.Settings;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.Level;

public class LogConfigurator {
    public static void configureWithoutConfig(Settings settings) {
        Objects.requireNonNull(settings);
        LogConfigurator.configureStatusLogger();
        LogConfigurator.configureLoggerLevels(settings);
    }

    private static void configureStatusLogger() {
        throw new UnsupportedOperationException();
    }

    private static void configureLoggerLevels(Settings settings) {
        if (ESLoggerFactory.LOG_DEFAULT_LEVEL_SETTING.exists(settings)) {
            Level level = ESLoggerFactory.LOG_DEFAULT_LEVEL_SETTING.get(settings);
            Loggers.setLevel(ESLoggerFactory.getRootLogger(), level);
        }
        Map<String, String> levels = settings.filter(ESLoggerFactory.LOG_LEVEL_SETTING::match).getAsMap();
        for (String key : levels.keySet()) {
            Level level = ESLoggerFactory.LOG_LEVEL_SETTING.getConcreteSetting(key).get(settings);
            Loggers.setLevel(ESLoggerFactory.getLogger(key.substring("logger.".length())), level);
        }
    }
}

