/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.logging;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.codelibs.elasticsearch.common.logging.LoggerMessageFormat;
import org.codelibs.elasticsearch.common.util.concurrent.ThreadContext;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.LogManager;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.Logger;

public class DeprecationLogger {
    private final Logger logger;
    public static final String WARNING_HEADER = "Warning";
    private static final CopyOnWriteArraySet<ThreadContext> THREAD_CONTEXT = new CopyOnWriteArraySet();

    public static void setThreadContext(ThreadContext threadContext) {
        Objects.requireNonNull(threadContext, "Cannot register a null ThreadContext");
        if (!THREAD_CONTEXT.add(threadContext)) {
            throw new IllegalStateException("Double-setting ThreadContext not allowed!");
        }
    }

    public static void removeThreadContext(ThreadContext threadContext) {
        assert (threadContext != null);
        if (!THREAD_CONTEXT.remove(threadContext)) {
            throw new IllegalStateException("Removing unknown ThreadContext not allowed!");
        }
    }

    public DeprecationLogger(Logger parentLogger) {
        String name = parentLogger.getName();
        name = name.startsWith("org.codelibs.elasticsearch") ? name.replace("org.codelibs.elasticsearch.", "org.codelibs.elasticsearch.deprecation.") : "deprecation." + name;
        this.logger = LogManager.getLogger(name);
    }

    public void deprecated(String msg, Object ... params) {
        this.deprecated(THREAD_CONTEXT, msg, params);
    }

    void deprecated(Set<ThreadContext> threadContexts, String message, Object ... params) {
        Iterator<ThreadContext> iterator = threadContexts.iterator();
        if (iterator.hasNext()) {
            String formattedMessage = LoggerMessageFormat.format(message, params);
            while (iterator.hasNext()) {
                try {
                    iterator.next().addResponseHeader(WARNING_HEADER, formattedMessage);
                }
                catch (IllegalStateException illegalStateException) {}
            }
            this.logger.warn(formattedMessage);
        } else {
            this.logger.warn(message, params);
        }
    }
}

