/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.io.stream;

import java.io.IOException;
import org.codelibs.elasticsearch.ElasticsearchException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;

public final class NotSerializableExceptionWrapper
extends ElasticsearchException {
    private final String name;

    public NotSerializableExceptionWrapper(Throwable other) {
        super(ElasticsearchException.getExceptionName(other) + ": " + other.getMessage(), other.getCause(), new Object[0]);
        this.name = ElasticsearchException.getExceptionName(other);
        this.setStackTrace(other.getStackTrace());
        for (Throwable otherSuppressed : other.getSuppressed()) {
            this.addSuppressed(otherSuppressed);
        }
        if (other instanceof ElasticsearchException) {
            ElasticsearchException ex = (ElasticsearchException)other;
            for (String key : ex.getHeaderKeys()) {
                this.addHeader(key, ex.getHeader(key));
            }
        }
    }

    public NotSerializableExceptionWrapper(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
    }

    @Override
    protected String getExceptionName() {
        return this.name;
    }
}

