/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.io.stream;

import java.io.IOException;
import org.codelibs.elasticsearch.common.io.stream.FilterStreamInput;
import org.codelibs.elasticsearch.common.io.stream.NamedWriteable;
import org.codelibs.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;

public class NamedWriteableAwareStreamInput
extends FilterStreamInput {
    private final NamedWriteableRegistry namedWriteableRegistry;

    public NamedWriteableAwareStreamInput(StreamInput delegate, NamedWriteableRegistry namedWriteableRegistry) {
        super(delegate);
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass) throws IOException {
        String name = this.readString();
        return this.readNamedWriteable(categoryClass, name);
    }

    @Override
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass, String name) throws IOException {
        Writeable.Reader<C> reader = this.namedWriteableRegistry.getReader(categoryClass, name);
        NamedWriteable c = (NamedWriteable)reader.read(this);
        if (c == null) {
            throw new IOException("Writeable.Reader [" + reader + "] returned null which is not allowed and probably means it screwed up the stream.");
        }
        assert (name.equals(c.getWriteableName())) : c + " claims to have a different name [" + c.getWriteableName() + "] than it was read from [" + name + "].";
        return (C)c;
    }
}

