/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.List;
import org.codelibs.elasticsearch.common.geo.builders.CircleBuilder;
import org.codelibs.elasticsearch.common.geo.builders.CoordinatesBuilder;
import org.codelibs.elasticsearch.common.geo.builders.EnvelopeBuilder;
import org.codelibs.elasticsearch.common.geo.builders.GeometryCollectionBuilder;
import org.codelibs.elasticsearch.common.geo.builders.LineStringBuilder;
import org.codelibs.elasticsearch.common.geo.builders.MultiLineStringBuilder;
import org.codelibs.elasticsearch.common.geo.builders.MultiPointBuilder;
import org.codelibs.elasticsearch.common.geo.builders.MultiPolygonBuilder;
import org.codelibs.elasticsearch.common.geo.builders.PointBuilder;
import org.codelibs.elasticsearch.common.geo.builders.PolygonBuilder;
import org.codelibs.elasticsearch.common.geo.builders.ShapeBuilder;
import org.codelibs.elasticsearch.common.io.stream.NamedWriteableRegistry;

public class ShapeBuilders {
    public static PointBuilder newPoint(double longitude, double latitude) {
        return ShapeBuilders.newPoint(new Coordinate(longitude, latitude));
    }

    public static PointBuilder newPoint(Coordinate coordinate) {
        return new PointBuilder().coordinate(coordinate);
    }

    public static MultiPointBuilder newMultiPoint(List<Coordinate> points) {
        return new MultiPointBuilder(points);
    }

    public static LineStringBuilder newLineString(List<Coordinate> list) {
        return new LineStringBuilder(list);
    }

    public static LineStringBuilder newLineString(CoordinatesBuilder coordinates) {
        return new LineStringBuilder(coordinates);
    }

    public static MultiLineStringBuilder newMultiLinestring() {
        return new MultiLineStringBuilder();
    }

    public static PolygonBuilder newPolygon(List<Coordinate> shell) {
        return new PolygonBuilder(new CoordinatesBuilder().coordinates(shell));
    }

    public static PolygonBuilder newPolygon(CoordinatesBuilder shell) {
        return new PolygonBuilder(shell);
    }

    public static MultiPolygonBuilder newMultiPolygon() {
        return new MultiPolygonBuilder();
    }

    public static MultiPolygonBuilder newMultiPolygon(ShapeBuilder.Orientation orientation) {
        return new MultiPolygonBuilder(orientation);
    }

    public static GeometryCollectionBuilder newGeometryCollection() {
        return new GeometryCollectionBuilder();
    }

    public static CircleBuilder newCircleBuilder() {
        return new CircleBuilder();
    }

    public static EnvelopeBuilder newEnvelope(Coordinate topLeft, Coordinate bottomRight) {
        return new EnvelopeBuilder(topLeft, bottomRight);
    }

    public static void register(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, PointBuilder.TYPE.shapeName(), PointBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, CircleBuilder.TYPE.shapeName(), CircleBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, EnvelopeBuilder.TYPE.shapeName(), EnvelopeBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, MultiPointBuilder.TYPE.shapeName(), MultiPointBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, LineStringBuilder.TYPE.shapeName(), LineStringBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, MultiLineStringBuilder.TYPE.shapeName(), MultiLineStringBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, PolygonBuilder.TYPE.shapeName(), PolygonBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, MultiPolygonBuilder.TYPE.shapeName(), MultiPolygonBuilder::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ShapeBuilder.class, GeometryCollectionBuilder.TYPE.shapeName(), GeometryCollectionBuilder::new));
    }
}

