/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.Objects;
import org.codelibs.elasticsearch.common.geo.builders.ShapeBuilder;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.shape.Point;

public class PointBuilder
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.POINT;
    private Coordinate coordinate;

    public PointBuilder() {
        this.coordinate = ZERO_ZERO;
    }

    public PointBuilder(StreamInput in) throws IOException {
        this.coordinate = PointBuilder.readFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        PointBuilder.writeCoordinateTo(this.coordinate, out);
    }

    public PointBuilder coordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
        return this;
    }

    public double longitude() {
        return this.coordinate.x;
    }

    public double latitude() {
        return this.coordinate.y;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE.shapeName());
        builder.field("coordinates");
        PointBuilder.toXContent(builder, this.coordinate);
        return builder.endObject();
    }

    public Point build() {
        return SPATIAL_CONTEXT.makePoint(this.coordinate.x, this.coordinate.y);
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    public int hashCode() {
        return Objects.hash(this.coordinate);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PointBuilder other = (PointBuilder)obj;
        return Objects.equals(this.coordinate, other.coordinate);
    }
}

