/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.codelibs.elasticsearch.common.geo.XShapeCollection;
import org.codelibs.elasticsearch.common.geo.builders.CoordinateCollection;
import org.codelibs.elasticsearch.common.geo.builders.ShapeBuilder;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class MultiPointBuilder
extends CoordinateCollection<MultiPointBuilder> {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.MULTIPOINT;

    public MultiPointBuilder(List<Coordinate> coordinates) {
        super(coordinates);
    }

    public MultiPointBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE.shapeName());
        builder.field("coordinates");
        super.coordinatesToXcontent(builder, false);
        builder.endObject();
        return builder;
    }

    @Override
    public Shape build() {
        ArrayList<Point> shapes = new ArrayList<Point>(this.coordinates.size());
        for (Coordinate coord : this.coordinates) {
            shapes.add(SPATIAL_CONTEXT.makePoint(coord.x, coord.y));
        }
        XShapeCollection multiPoints = new XShapeCollection(shapes, (SpatialContext)SPATIAL_CONTEXT);
        multiPoints.setPointsOnly(true);
        return multiPoints;
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    public int hashCode() {
        return Objects.hash(this.coordinates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiPointBuilder other = (MultiPointBuilder)obj;
        return Objects.equals(this.coordinates, other.coordinates);
    }
}

