/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.codelibs.elasticsearch.common.geo.builders.LineStringBuilder;
import org.codelibs.elasticsearch.common.geo.builders.ShapeBuilder;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.shape.Shape;

public class MultiLineStringBuilder
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.MULTILINESTRING;
    private final ArrayList<LineStringBuilder> lines = new ArrayList();

    public MultiLineStringBuilder() {
    }

    public MultiLineStringBuilder(StreamInput in) throws IOException {
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.linestring(new LineStringBuilder(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.lines.size());
        for (LineStringBuilder line : this.lines) {
            line.writeTo(out);
        }
    }

    public MultiLineStringBuilder linestring(LineStringBuilder line) {
        this.lines.add(line);
        return this;
    }

    public Coordinate[][] coordinates() {
        Coordinate[][] result = new Coordinate[this.lines.size()][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.lines.get(i).coordinates(false);
        }
        return result;
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE.shapeName());
        builder.field("coordinates");
        builder.startArray();
        for (LineStringBuilder line : this.lines) {
            line.coordinatesToXcontent(builder, false);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public Shape build() {
        MultiLineString geometry;
        if (this.wrapdateline) {
            ArrayList<LineString> parts = new ArrayList<LineString>();
            for (LineStringBuilder line : this.lines) {
                LineStringBuilder.decompose(FACTORY, line.coordinates(false), parts);
            }
            if (parts.size() == 1) {
                geometry = (Geometry)parts.get(0);
            } else {
                LineString[] lineStrings = parts.toArray(new LineString[parts.size()]);
                geometry = FACTORY.createMultiLineString(lineStrings);
            }
        } else {
            LineString[] lineStrings = new LineString[this.lines.size()];
            Iterator<LineStringBuilder> iterator = this.lines.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                lineStrings[i] = FACTORY.createLineString(iterator.next().coordinates(false));
                ++i;
            }
            geometry = FACTORY.createMultiLineString(lineStrings);
        }
        return this.jtsGeometry((Geometry)geometry);
    }

    public int hashCode() {
        return Objects.hash(this.lines);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiLineStringBuilder other = (MultiLineStringBuilder)obj;
        return Objects.equals(this.lines, other.lines);
    }
}

