/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.geo.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.codelibs.elasticsearch.ElasticsearchException;
import org.codelibs.elasticsearch.common.geo.XShapeCollection;
import org.codelibs.elasticsearch.common.geo.builders.CircleBuilder;
import org.codelibs.elasticsearch.common.geo.builders.EnvelopeBuilder;
import org.codelibs.elasticsearch.common.geo.builders.LineStringBuilder;
import org.codelibs.elasticsearch.common.geo.builders.MultiLineStringBuilder;
import org.codelibs.elasticsearch.common.geo.builders.MultiPointBuilder;
import org.codelibs.elasticsearch.common.geo.builders.MultiPolygonBuilder;
import org.codelibs.elasticsearch.common.geo.builders.PointBuilder;
import org.codelibs.elasticsearch.common.geo.builders.PolygonBuilder;
import org.codelibs.elasticsearch.common.geo.builders.ShapeBuilder;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public class GeometryCollectionBuilder
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.GEOMETRYCOLLECTION;
    final List<ShapeBuilder> shapes = new ArrayList<ShapeBuilder>();

    public GeometryCollectionBuilder() {
    }

    public GeometryCollectionBuilder(StreamInput in) throws IOException {
        int shapes = in.readVInt();
        for (int i = 0; i < shapes; ++i) {
            this.shape(in.readNamedWriteable(ShapeBuilder.class));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shapes.size());
        for (ShapeBuilder shape : this.shapes) {
            out.writeNamedWriteable(shape);
        }
    }

    public GeometryCollectionBuilder shape(ShapeBuilder shape) {
        this.shapes.add(shape);
        return this;
    }

    public GeometryCollectionBuilder point(PointBuilder point) {
        this.shapes.add(point);
        return this;
    }

    public GeometryCollectionBuilder multiPoint(MultiPointBuilder multiPoint) {
        this.shapes.add(multiPoint);
        return this;
    }

    public GeometryCollectionBuilder line(LineStringBuilder line) {
        this.shapes.add(line);
        return this;
    }

    public GeometryCollectionBuilder multiLine(MultiLineStringBuilder multiLine) {
        this.shapes.add(multiLine);
        return this;
    }

    public GeometryCollectionBuilder polygon(PolygonBuilder polygon) {
        this.shapes.add(polygon);
        return this;
    }

    public GeometryCollectionBuilder multiPolygon(MultiPolygonBuilder multiPolygon) {
        this.shapes.add(multiPolygon);
        return this;
    }

    public GeometryCollectionBuilder envelope(EnvelopeBuilder envelope) {
        this.shapes.add(envelope);
        return this;
    }

    public GeometryCollectionBuilder circle(CircleBuilder circle) {
        this.shapes.add(circle);
        return this;
    }

    public ShapeBuilder getShapeAt(int i) {
        if (i >= this.shapes.size() || i < 0) {
            throw new ElasticsearchException("GeometryCollection contains " + this.shapes.size() + " shapes. + " + "No shape found at index " + i, new Object[0]);
        }
        return this.shapes.get(i);
    }

    public int numShapes() {
        return this.shapes.size();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE.shapeName());
        builder.startArray("geometries");
        for (ShapeBuilder shape : this.shapes) {
            shape.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    @Override
    public Shape build() {
        ArrayList<Shape> shapes = new ArrayList<Shape>(this.shapes.size());
        for (ShapeBuilder shape : this.shapes) {
            shapes.add(shape.build());
        }
        if (shapes.size() == 1) {
            return (Shape)shapes.get(0);
        }
        return new XShapeCollection(shapes, (SpatialContext)SPATIAL_CONTEXT);
    }

    public int hashCode() {
        return Objects.hash(this.shapes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryCollectionBuilder other = (GeometryCollectionBuilder)obj;
        return Objects.equals(this.shapes, other.shapes);
    }
}

