/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.compress;

import java.io.IOException;
import java.io.OutputStream;
import org.codelibs.elasticsearch.common.Nullable;
import org.codelibs.elasticsearch.common.bytes.BytesReference;
import org.codelibs.elasticsearch.common.compress.Compressor;
import org.codelibs.elasticsearch.common.compress.DeflateCompressor;
import org.codelibs.elasticsearch.common.compress.NotCompressedException;
import org.codelibs.elasticsearch.common.compress.NotXContentException;
import org.codelibs.elasticsearch.common.io.Streams;
import org.codelibs.elasticsearch.common.io.stream.BytesStreamOutput;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.xcontent.XContentFactory;
import org.codelibs.elasticsearch.common.xcontent.XContentType;

public class CompressorFactory {
    public static final Compressor COMPRESSOR = new DeflateCompressor();

    public static boolean isCompressed(BytesReference bytes) {
        return CompressorFactory.compressor(bytes) != null;
    }

    @Nullable
    public static Compressor compressor(BytesReference bytes) {
        if (COMPRESSOR.isCompressed(bytes)) {
            assert (XContentFactory.xContentType(bytes) == null);
            return COMPRESSOR;
        }
        XContentType contentType = XContentFactory.xContentType(bytes);
        if (contentType == null) {
            if (CompressorFactory.isAncient(bytes)) {
                throw new IllegalStateException("unsupported compression: index was created before v2.0.0.beta1 and wasn't upgraded?");
            }
            throw new NotXContentException("Compressor detection can only be called on some xcontent bytes or compressed xcontent bytes");
        }
        return null;
    }

    private static boolean isAncient(BytesReference bytes) {
        return bytes.length() >= 3 && bytes.get(0) == 90 && bytes.get(1) == 86 && (bytes.get(2) == 0 || bytes.get(2) == 1);
    }

    public static BytesReference uncompressIfNeeded(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        BytesReference uncompressed = compressor != null ? CompressorFactory.uncompress(bytes, compressor) : bytes;
        return uncompressed;
    }

    public static BytesReference uncompress(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor == null) {
            throw new NotCompressedException();
        }
        return CompressorFactory.uncompress(bytes, compressor);
    }

    private static BytesReference uncompress(BytesReference bytes, Compressor compressor) throws IOException {
        StreamInput compressed = compressor.streamInput(bytes.streamInput());
        BytesStreamOutput bStream = new BytesStreamOutput();
        Streams.copy(compressed, (OutputStream)bStream);
        compressed.close();
        return bStream.bytes();
    }
}

