/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.compress;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.lucene.util.BytesRef;
import org.codelibs.elasticsearch.common.bytes.BytesArray;
import org.codelibs.elasticsearch.common.bytes.BytesReference;
import org.codelibs.elasticsearch.common.compress.Compressor;
import org.codelibs.elasticsearch.common.compress.CompressorFactory;
import org.codelibs.elasticsearch.common.io.stream.BytesStreamOutput;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentFactory;
import org.codelibs.elasticsearch.common.xcontent.XContentType;

public final class CompressedXContent {
    private final byte[] bytes;
    private final int crc32;

    private static int crc32(BytesReference data) {
        OutputStream dummy = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
            }
        };
        CRC32 crc32 = new CRC32();
        try {
            data.writeTo(new CheckedOutputStream(dummy, crc32));
        }
        catch (IOException bogus) {
            throw new Error(bogus);
        }
        return (int)crc32.getValue();
    }

    private CompressedXContent(byte[] compressed, int crc32) {
        this.bytes = compressed;
        this.crc32 = crc32;
        this.assertConsistent();
    }

    public CompressedXContent(ToXContent xcontent, XContentType type, ToXContent.Params params) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        StreamOutput compressedStream = CompressorFactory.COMPRESSOR.streamOutput(bStream);
        CRC32 crc32 = new CRC32();
        CheckedOutputStream checkedStream = new CheckedOutputStream(compressedStream, crc32);
        try (XContentBuilder builder = XContentFactory.contentBuilder(type, checkedStream);){
            builder.startObject();
            xcontent.toXContent(builder, params);
            builder.endObject();
        }
        this.bytes = BytesReference.toBytes(bStream.bytes());
        this.crc32 = (int)crc32.getValue();
        this.assertConsistent();
    }

    public CompressedXContent(BytesReference data) throws IOException {
        Compressor compressor = CompressorFactory.compressor(data);
        if (compressor != null) {
            this.bytes = BytesReference.toBytes(data);
            this.crc32 = CompressedXContent.crc32(new BytesArray(this.uncompressed()));
        } else {
            BytesStreamOutput out = new BytesStreamOutput();
            try (StreamOutput compressedOutput = CompressorFactory.COMPRESSOR.streamOutput(out);){
                data.writeTo(compressedOutput);
            }
            this.bytes = BytesReference.toBytes(out.bytes());
            this.crc32 = CompressedXContent.crc32(data);
        }
        this.assertConsistent();
    }

    private void assertConsistent() {
        assert (CompressorFactory.compressor(new BytesArray(this.bytes)) != null);
        assert (this.crc32 == CompressedXContent.crc32(new BytesArray(this.uncompressed())));
    }

    public CompressedXContent(byte[] data) throws IOException {
        this(new BytesArray(data));
    }

    public CompressedXContent(String str) throws IOException {
        this(new BytesArray(new BytesRef((CharSequence)str)));
    }

    public byte[] compressed() {
        return this.bytes;
    }

    public BytesReference compressedReference() {
        return new BytesArray(this.bytes);
    }

    public byte[] uncompressed() {
        try {
            return BytesReference.toBytes(CompressorFactory.uncompress(new BytesArray(this.bytes)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot decompress compressed string", e);
        }
    }

    public String string() throws IOException {
        return new BytesRef(this.uncompressed()).utf8ToString();
    }

    public static CompressedXContent readCompressedString(StreamInput in) throws IOException {
        int crc32 = in.readInt();
        byte[] compressed = new byte[in.readVInt()];
        in.readBytes(compressed, 0, compressed.length);
        return new CompressedXContent(compressed, crc32);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.crc32);
        out.writeVInt(this.bytes.length);
        out.writeBytes(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressedXContent that = (CompressedXContent)o;
        if (Arrays.equals(this.compressed(), that.compressed())) {
            return true;
        }
        if (this.crc32 != that.crc32) {
            return false;
        }
        return Arrays.equals(this.uncompressed(), that.uncompressed());
    }

    public int hashCode() {
        return this.crc32;
    }

    public String toString() {
        try {
            return this.string();
        }
        catch (IOException e) {
            return "_na_";
        }
    }
}

