/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.common.breaker;

import java.io.IOException;
import org.codelibs.elasticsearch.ElasticsearchException;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;

public class CircuitBreakingException
extends ElasticsearchException {
    private final long bytesWanted;
    private final long byteLimit;

    public CircuitBreakingException(String message) {
        super(message, new Object[0]);
        this.bytesWanted = 0L;
        this.byteLimit = 0L;
    }

    public CircuitBreakingException(StreamInput in) throws IOException {
        super(in);
        this.byteLimit = in.readLong();
        this.bytesWanted = in.readLong();
    }

    public CircuitBreakingException(String message, long bytesWanted, long byteLimit) {
        super(message, new Object[0]);
        this.bytesWanted = bytesWanted;
        this.byteLimit = byteLimit;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.byteLimit);
        out.writeLong(this.bytesWanted);
    }

    @Override
    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("bytes_wanted", this.bytesWanted);
        builder.field("bytes_limit", this.byteLimit);
        super.innerToXContent(builder, params);
    }
}

