/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.action.support;

import org.codelibs.elasticsearch.ElasticsearchException;
import org.codelibs.elasticsearch.ExceptionsHelper;
import org.codelibs.elasticsearch.client.Requests;
import org.codelibs.elasticsearch.common.bytes.BytesReference;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentFactory;
import org.codelibs.elasticsearch.common.xcontent.XContentType;

public abstract class ToXContentToBytes
implements ToXContent {
    private final XContentType defaultType;

    protected ToXContentToBytes() {
        this.defaultType = Requests.CONTENT_TYPE;
    }

    protected ToXContentToBytes(XContentType defaultType) {
        this.defaultType = defaultType;
    }

    public final BytesReference buildAsBytes() {
        return this.buildAsBytes(this.defaultType);
    }

    public final BytesReference buildAsBytes(XContentType contentType) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.bytes();
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to build ToXContent", (Throwable)e, new Object[0]);
        }
    }

    public final String toString() {
        return this.toString(EMPTY_PARAMS);
    }

    public final String toString(ToXContent.Params params) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            if (params.paramAsBoolean("pretty", true)) {
                builder.prettyPrint();
            }
            this.toXContent(builder, params);
            return builder.string();
        }
        catch (Exception e) {
            return "{ \"error\" : \"" + ExceptionsHelper.detailedMessage(e) + "\"}";
        }
    }
}

