/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.codelibs.elasticsearch.ElasticsearchException;
import org.codelibs.elasticsearch.ElasticsearchWrapperException;
import org.codelibs.elasticsearch.common.Nullable;
import org.codelibs.elasticsearch.common.logging.Loggers;
import org.codelibs.elasticsearch.querybuilders.mock.log4j.Logger;

public final class ExceptionsHelper {
    private static final Logger logger = Loggers.getLogger(ExceptionsHelper.class);

    public static RuntimeException convertToRuntime(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new ElasticsearchException(e);
    }

    public static ElasticsearchException convertToElastic(Exception e) {
        if (e instanceof ElasticsearchException) {
            return (ElasticsearchException)e;
        }
        return new ElasticsearchException(e);
    }

    public static Throwable unwrapCause(Throwable t) {
        int counter = 0;
        Throwable result = t;
        while (result instanceof ElasticsearchWrapperException) {
            if (result.getCause() == null) {
                return result;
            }
            if (result.getCause() == result) {
                return result;
            }
            if (counter++ > 10) {
                logger.warn("Exception cause unwrapping ran for 10 levels...", t);
                return result;
            }
            result = result.getCause();
        }
        return result;
    }

    @Deprecated
    public static String detailedMessage(Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        if (t.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            while (t != null) {
                sb.append(t.getClass().getSimpleName());
                if (t.getMessage() != null) {
                    sb.append("[");
                    sb.append(t.getMessage());
                    sb.append("]");
                }
                sb.append("; ");
                if ((t = t.getCause()) == null) continue;
                sb.append("nested: ");
            }
            return sb.toString();
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }

    public static String stackTrace(Throwable e) {
        StringWriter stackTraceStringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTraceStringWriter);
        e.printStackTrace(printWriter);
        return stackTraceStringWriter.toString();
    }

    public static <T extends Throwable> void rethrowAndSuppress(List<T> exceptions) throws T {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw main;
        }
    }

    public static <T extends Throwable> void maybeThrowRuntimeAndSuppress(List<T> exceptions) {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw new ElasticsearchException(main);
        }
    }

    public static <T extends Throwable> T useOrSuppress(T first, T second) {
        if (first == null) {
            return second;
        }
        first.addSuppressed(second);
        return first;
    }

    public static IOException unwrapCorruption(Throwable t) {
        return (IOException)ExceptionsHelper.unwrap(t, CorruptIndexException.class, IndexFormatTooOldException.class, IndexFormatTooNewException.class);
    }

    public static Throwable unwrap(Throwable t, Class<?> ... clazzes) {
        if (t != null) {
            do {
                for (Class<?> clazz : clazzes) {
                    if (!clazz.isInstance(t)) continue;
                    return t;
                }
            } while ((t = t.getCause()) != null);
        }
        return null;
    }

    public static boolean reThrowIfNotNull(@Nullable Throwable e) {
        if (e != null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return true;
    }
}

