/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codelibs.elasticsearch.ElasticsearchParseException;
import org.codelibs.elasticsearch.ExceptionsHelper;
import org.codelibs.elasticsearch.Version;
import org.codelibs.elasticsearch.common.ParsingException;
import org.codelibs.elasticsearch.common.breaker.CircuitBreakingException;
import org.codelibs.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.logging.LoggerMessageFormat;
import org.codelibs.elasticsearch.common.lucene.Lucene;
import org.codelibs.elasticsearch.common.settings.NoClassSettingsException;
import org.codelibs.elasticsearch.common.settings.SettingsException;
import org.codelibs.elasticsearch.common.util.CancellableThreads;
import org.codelibs.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.codelibs.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.codelibs.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;
import org.codelibs.elasticsearch.common.xcontent.XContentBuilder;
import org.codelibs.elasticsearch.common.xcontent.XContentParser;
import org.codelibs.elasticsearch.common.xcontent.XContentParserUtils;
import org.codelibs.elasticsearch.index.mapper.MapperException;
import org.codelibs.elasticsearch.index.mapper.MapperParsingException;
import org.codelibs.elasticsearch.index.query.QueryShardException;
import org.codelibs.elasticsearch.script.ScriptException;
import org.codelibs.elasticsearch.search.SearchContextException;
import org.codelibs.elasticsearch.search.SearchException;
import org.codelibs.elasticsearch.search.SearchParseException;
import org.codelibs.elasticsearch.search.aggregations.AggregationExecutionException;
import org.codelibs.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.codelibs.elasticsearch.search.builder.SearchSourceBuilderException;
import org.codelibs.elasticsearch.search.fetch.FetchPhaseExecutionException;

public class ElasticsearchException
extends RuntimeException
implements ToXContent,
Writeable {
    static final Version UNKNOWN_VERSION_ADDED = Version.fromId(0);
    public static final String REST_EXCEPTION_SKIP_CAUSE = "rest.exception.cause.skip";
    public static final String REST_EXCEPTION_SKIP_STACK_TRACE = "rest.exception.stacktrace.skip";
    public static final boolean REST_EXCEPTION_SKIP_STACK_TRACE_DEFAULT = true;
    public static final boolean REST_EXCEPTION_SKIP_CAUSE_DEFAULT = false;
    private static final String RESOURCE_HEADER_TYPE_KEY = "es.resource.type";
    private static final String RESOURCE_HEADER_ID_KEY = "es.resource.id";
    private static final String TYPE = "type";
    private static final String REASON = "reason";
    private static final String CAUSED_BY = "caused_by";
    private static final String STACK_TRACE = "stack_trace";
    private static final String HEADER = "header";
    private static final String ERROR = "error";
    private static final String ROOT_CAUSE = "root_cause";
    private static final Map<Integer, FunctionThatThrowsIOException<StreamInput, ? extends ElasticsearchException>> ID_TO_SUPPLIER = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.id, e -> e.constructor)));
    private static final Map<Class<? extends ElasticsearchException>, ElasticsearchExceptionHandle> CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.exceptionClass, e -> e)));
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public ElasticsearchException(Throwable cause) {
        super(cause);
    }

    public ElasticsearchException(String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args));
    }

    public ElasticsearchException(String msg, Throwable cause, Object ... args) {
        super(LoggerMessageFormat.format(msg, args), cause);
    }

    public ElasticsearchException(StreamInput in) throws IOException {
        super(in.readOptionalString(), (Throwable)in.readException());
        ElasticsearchException.readStackTrace(this, in);
        this.headers.putAll(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
    }

    public void addHeader(String key, String ... value) {
        this.headers.put(key, Arrays.asList(value));
    }

    public void addHeader(String key, List<String> value) {
        this.headers.put(key, value);
    }

    public Set<String> getHeaderKeys() {
        return this.headers.keySet();
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof ElasticsearchException) {
                sb.append(((ElasticsearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.getMessage());
        out.writeException(this.getCause());
        ElasticsearchException.writeStackTraces(this, out);
        out.writeMapOfLists(this.headers, StreamOutput::writeString, StreamOutput::writeString);
    }

    public static ElasticsearchException readException(StreamInput input, int id) throws IOException {
        FunctionThatThrowsIOException<StreamInput, ? extends ElasticsearchException> elasticsearchException = ID_TO_SUPPLIER.get(id);
        if (elasticsearchException == null) {
            throw new IllegalStateException("unknown exception for id: " + id);
        }
        return elasticsearchException.apply(input);
    }

    public static boolean isRegistered(Class<? extends Throwable> exception, Version version) {
        ElasticsearchExceptionHandle elasticsearchExceptionHandle = CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.get(exception);
        if (elasticsearchExceptionHandle != null) {
            return version.onOrAfter(elasticsearchExceptionHandle.versionAdded);
        }
        return false;
    }

    static Set<Class<? extends ElasticsearchException>> getRegisteredKeys() {
        return CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.keySet();
    }

    public static int getId(Class<? extends ElasticsearchException> exception) {
        return ElasticsearchException.CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.get(exception).id;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause(this);
        if (ex != this) {
            ElasticsearchException.toXContent(builder, params, this);
        } else {
            builder.field(TYPE, this.getExceptionName());
            builder.field(REASON, this.getMessage());
            for (String key : this.headers.keySet()) {
                if (!key.startsWith("es.")) continue;
                List<String> values = this.headers.get(key);
                this.xContentHeader(builder, key.substring("es.".length()), values);
            }
            this.innerToXContent(builder, params);
            this.renderHeader(builder, params);
            if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
                builder.field(STACK_TRACE, ExceptionsHelper.stackTrace(this));
            }
        }
        return builder;
    }

    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.causeToXContent(builder, params);
    }

    protected void causeToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable cause = this.getCause();
        if (cause != null && !params.paramAsBoolean(REST_EXCEPTION_SKIP_CAUSE, false)) {
            builder.field(CAUSED_BY);
            builder.startObject();
            ElasticsearchException.toXContent(builder, params, cause);
            builder.endObject();
        }
    }

    protected final void renderHeader(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasHeader = false;
        for (String key : this.headers.keySet()) {
            if (key.startsWith("es.")) continue;
            if (!hasHeader) {
                builder.startObject(HEADER);
                hasHeader = true;
            }
            List<String> values = this.headers.get(key);
            this.xContentHeader(builder, key, values);
        }
        if (hasHeader) {
            builder.endObject();
        }
    }

    private void xContentHeader(XContentBuilder builder, String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                builder.field(key, values.get(0));
            } else {
                builder.startArray(key);
                for (String value : values) {
                    builder.value(value);
                }
                builder.endArray();
            }
        }
    }

    public static void toXContent(XContentBuilder builder, ToXContent.Params params, Throwable ex) throws IOException {
        if ((ex = ExceptionsHelper.unwrapCause(ex)) instanceof ElasticsearchException) {
            ((ElasticsearchException)ex).toXContent(builder, params);
        } else {
            builder.field(TYPE, ElasticsearchException.getExceptionName(ex));
            builder.field(REASON, ex.getMessage());
            if (ex.getCause() != null) {
                builder.field(CAUSED_BY);
                builder.startObject();
                ElasticsearchException.toXContent(builder, params, ex.getCause());
                builder.endObject();
            }
            if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
                builder.field(STACK_TRACE, ExceptionsHelper.stackTrace(ex));
            }
        }
    }

    public static ElasticsearchException fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        String type = null;
        String reason = null;
        String stack = null;
        ElasticsearchException cause = null;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        do {
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token.isValue()) {
                if (TYPE.equals(currentFieldName)) {
                    type = parser.text();
                    continue;
                }
                if (REASON.equals(currentFieldName)) {
                    reason = parser.text();
                    continue;
                }
                if (STACK_TRACE.equals(currentFieldName)) {
                    stack = parser.text();
                    continue;
                }
                headers.put(currentFieldName, parser.text());
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if (CAUSED_BY.equals(currentFieldName)) {
                cause = ElasticsearchException.fromXContent(parser);
                continue;
            }
            if (HEADER.equals(currentFieldName)) {
                headers.putAll(parser.map());
                continue;
            }
            XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
        } while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME);
        StringBuilder message = new StringBuilder("Elasticsearch exception [");
        message.append(TYPE).append('=').append(type).append(", ");
        message.append(REASON).append('=').append(reason);
        if (stack != null) {
            message.append(", ").append(STACK_TRACE).append('=').append(stack);
        }
        message.append(']');
        ElasticsearchException e = new ElasticsearchException(message.toString(), (Throwable)cause, new Object[0]);
        for (Map.Entry header : headers.entrySet()) {
            e.addHeader((String)header.getKey(), String.valueOf(header.getValue()));
        }
        return e;
    }

    public ElasticsearchException[] guessRootCauses() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ElasticsearchException) {
            return ((ElasticsearchException)cause).guessRootCauses();
        }
        return new ElasticsearchException[]{this};
    }

    public static ElasticsearchException[] guessRootCauses(Throwable t) {
        Throwable ex = ExceptionsHelper.unwrapCause(t);
        if (ex instanceof ElasticsearchException) {
            return ((ElasticsearchException)ex).guessRootCauses();
        }
        return new ElasticsearchException[]{new ElasticsearchException(t.getMessage(), t, new Object[0]){

            @Override
            protected String getExceptionName() {
                return 1.getExceptionName(this.getCause());
            }
        }};
    }

    protected String getExceptionName() {
        return ElasticsearchException.getExceptionName(this);
    }

    public static String getExceptionName(Throwable ex) {
        String simpleName = ex.getClass().getSimpleName();
        if (simpleName.startsWith("Elasticsearch")) {
            simpleName = simpleName.substring("Elasticsearch".length());
        }
        return ElasticsearchException.toUnderscoreCase(simpleName);
    }

    public static <T extends Throwable> T readStackTrace(T throwable, StreamInput in) throws IOException {
        int stackTraceElements = in.readVInt();
        StackTraceElement[] stackTrace = new StackTraceElement[stackTraceElements];
        for (int i = 0; i < stackTraceElements; ++i) {
            String declaringClasss = in.readString();
            String fileName = in.readOptionalString();
            String methodName = in.readString();
            int lineNumber = in.readVInt();
            stackTrace[i] = new StackTraceElement(declaringClasss, methodName, fileName, lineNumber);
        }
        throwable.setStackTrace(stackTrace);
        int numSuppressed = in.readVInt();
        for (int i = 0; i < numSuppressed; ++i) {
            throwable.addSuppressed((Throwable)in.readException());
        }
        return throwable;
    }

    public static <T extends Throwable> T writeStackTraces(T throwable, StreamOutput out) throws IOException {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        out.writeVInt(stackTrace.length);
        for (StackTraceElement element : stackTrace) {
            out.writeString(element.getClassName());
            out.writeOptionalString(element.getFileName());
            out.writeString(element.getMethodName());
            out.writeVInt(element.getLineNumber());
        }
        Throwable[] suppressed = throwable.getSuppressed();
        out.writeVInt(suppressed.length);
        for (Throwable t : suppressed) {
            out.writeException(t);
        }
        return throwable;
    }

    public void setResources(String type, String ... id) {
        assert (type != null);
        this.addHeader(RESOURCE_HEADER_ID_KEY, id);
        this.addHeader(RESOURCE_HEADER_TYPE_KEY, type);
    }

    public List<String> getResourceId() {
        return this.getHeader(RESOURCE_HEADER_ID_KEY);
    }

    public String getResourceType() {
        List<String> header = this.getHeader(RESOURCE_HEADER_TYPE_KEY);
        if (header != null && !header.isEmpty()) {
            assert (header.size() == 1);
            return header.get(0);
        }
        return null;
    }

    public static void renderException(XContentBuilder builder, ToXContent.Params params, Exception e) throws IOException {
        builder.startObject(ERROR);
        ElasticsearchException[] rootCauses = ElasticsearchException.guessRootCauses(e);
        builder.field(ROOT_CAUSE);
        builder.startArray();
        for (ElasticsearchException rootCause : rootCauses) {
            builder.startObject();
            rootCause.toXContent(builder, new ToXContent.DelegatingMapParams(Collections.singletonMap(REST_EXCEPTION_SKIP_CAUSE, "true"), params));
            builder.endObject();
        }
        builder.endArray();
        ElasticsearchException.toXContent(builder, params, e);
        builder.endObject();
    }

    private static String toUnderscoreCase(String value) {
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!changed) {
                    for (int j = 0; j < i; ++j) {
                        sb.append(value.charAt(j));
                    }
                    changed = true;
                    if (i == 0) {
                        sb.append(Character.toLowerCase(c));
                        continue;
                    }
                    sb.append('_');
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (!changed) continue;
            sb.append(c);
        }
        if (!changed) {
            return value;
        }
        return sb.toString();
    }

    static interface FunctionThatThrowsIOException<T, R> {
        public R apply(T var1) throws IOException;
    }

    static enum ElasticsearchExceptionHandle {
        EXECUTION_CANCELLED_EXCEPTION(CancellableThreads.ExecutionCancelledException.class, CancellableThreads.ExecutionCancelledException::new, 2, UNKNOWN_VERSION_ADDED),
        ELASTICSEARCH_PARSE_EXCEPTION(ElasticsearchParseException.class, ElasticsearchParseException::new, 35, UNKNOWN_VERSION_ADDED),
        SEARCH_EXCEPTION(SearchException.class, SearchException::new, 36, UNKNOWN_VERSION_ADDED),
        MAPPER_EXCEPTION(MapperException.class, MapperException::new, 37, UNKNOWN_VERSION_ADDED),
        PARSING_EXCEPTION(ParsingException.class, ParsingException::new, 40, UNKNOWN_VERSION_ADDED),
        FETCH_PHASE_EXECUTION_EXCEPTION(FetchPhaseExecutionException.class, FetchPhaseExecutionException::new, 50, UNKNOWN_VERSION_ADDED),
        SETTINGS_EXCEPTION(SettingsException.class, SettingsException::new, 56, UNKNOWN_VERSION_ADDED),
        ES_REJECTED_EXECUTION_EXCEPTION(EsRejectedExecutionException.class, EsRejectedExecutionException::new, 59, UNKNOWN_VERSION_ADDED),
        EARLY_TERMINATION_EXCEPTION(Lucene.EarlyTerminationException.class, Lucene.EarlyTerminationException::new, 60, UNKNOWN_VERSION_ADDED),
        NOT_SERIALIZABLE_EXCEPTION_WRAPPER(NotSerializableExceptionWrapper.class, NotSerializableExceptionWrapper::new, 62, UNKNOWN_VERSION_ADDED),
        SEARCH_PARSE_EXCEPTION(SearchParseException.class, SearchParseException::new, 72, UNKNOWN_VERSION_ADDED),
        UNCATEGORIZED_EXECUTION_EXCEPTION(UncategorizedExecutionException.class, UncategorizedExecutionException::new, 77, UNKNOWN_VERSION_ADDED),
        AGGREGATION_EXECUTION_EXCEPTION(AggregationExecutionException.class, AggregationExecutionException::new, 86, UNKNOWN_VERSION_ADDED),
        NO_CLASS_SETTINGS_EXCEPTION(NoClassSettingsException.class, NoClassSettingsException::new, 111, UNKNOWN_VERSION_ADDED),
        INVALID_AGGREGATION_PATH_EXCEPTION(InvalidAggregationPathException.class, InvalidAggregationPathException::new, 121, UNKNOWN_VERSION_ADDED),
        MAPPER_PARSING_EXCEPTION(MapperParsingException.class, MapperParsingException::new, 126, UNKNOWN_VERSION_ADDED),
        SEARCH_CONTEXT_EXCEPTION(SearchContextException.class, SearchContextException::new, 127, UNKNOWN_VERSION_ADDED),
        SEARCH_SOURCE_BUILDER_EXCEPTION(SearchSourceBuilderException.class, SearchSourceBuilderException::new, 128, UNKNOWN_VERSION_ADDED),
        CIRCUIT_BREAKING_EXCEPTION(CircuitBreakingException.class, CircuitBreakingException::new, 133, UNKNOWN_VERSION_ADDED),
        QUERY_SHARD_EXCEPTION(QueryShardException.class, QueryShardException::new, 141, UNKNOWN_VERSION_ADDED),
        SCRIPT_EXCEPTION(ScriptException.class, ScriptException::new, 143, UNKNOWN_VERSION_ADDED),
        UNKNOWN_NAMED_OBJECT_EXCEPTION(NamedXContentRegistry.UnknownNamedObjectException.class, NamedXContentRegistry.UnknownNamedObjectException::new, 148, Version.V_5_2_0_UNRELEASED);

        final Class<? extends ElasticsearchException> exceptionClass;
        final FunctionThatThrowsIOException<StreamInput, ? extends ElasticsearchException> constructor;
        final int id;
        final Version versionAdded;

        private <E extends ElasticsearchException> ElasticsearchExceptionHandle(Class<E> exceptionClass, FunctionThatThrowsIOException<StreamInput, E> constructor, int id, Version versionAdded) {
            this.exceptionClass = exceptionClass;
            this.constructor = constructor;
            this.versionAdded = versionAdded;
            this.id = id;
        }
    }
}

