/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.codelibs.elasticsearch.search;

import org.codelibs.elasticsearch.common.io.stream.NamedWriteable;
import org.codelibs.elasticsearch.common.io.stream.StreamInput;
import org.codelibs.elasticsearch.common.io.stream.StreamOutput;
import org.codelibs.elasticsearch.common.io.stream.Writeable;
import org.codelibs.elasticsearch.common.xcontent.ToXContent;

/**
 * Intermediate serializable representation of a search ext section. To be subclassed by plugins that support
 * a custom section as part of a search request, which will be provided within the ext element.
 * Any state needs to be serialized as part of the {Writeable#writeTo(StreamOutput)} method and
 * read from the incoming stream, usually done adding a constructor that takes {StreamInput} as
 * an argument.
 *
 * the incoming request from the REST layer into the proper {SearchExtBuilder} subclass.
 *
 * {#getWriteableName()} must return the same name as the one used for the registration
 *
 * @see SearchExtParser
 */
public abstract class SearchExtBuilder implements NamedWriteable, ToXContent {

    @Override
    public abstract int hashCode();

    @Override
    public abstract boolean equals(Object obj);
}
