/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.zip;

import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.log.Logger;
import org.codelibs.core.misc.AssertionUtil;

public abstract class ZipInputStreamUtil {
    private static final Logger logger = Logger.getLogger(ZipInputStreamUtil.class);

    public static ZipEntry getNextEntry(ZipInputStream zis) {
        AssertionUtil.assertArgumentNotNull("zis", zis);
        try {
            return zis.getNextEntry();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void reset(ZipInputStream zis) {
        AssertionUtil.assertArgumentNotNull("zis", zis);
        try {
            zis.reset();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void closeEntry(ZipInputStream zis) {
        AssertionUtil.assertArgumentNotNull("zis", zis);
        try {
            zis.closeEntry();
        }
        catch (IOException e) {
            logger.log(Logger.format("ECL0017", e.getMessage()), e);
        }
    }
}

