/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.xml;

import java.io.File;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.codelibs.core.exception.SAXRuntimeException;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.xml.SchemaFactoryUtil;
import org.xml.sax.SAXException;

public abstract class SchemaUtil {
    public static Schema newW3cXmlSchema(File schema) {
        AssertionUtil.assertArgumentNotNull("schema", schema);
        return SchemaUtil.newSchema(SchemaFactoryUtil.newW3cXmlSchemaFactory(), schema);
    }

    public static Schema newW3cXmlSchema(Source schema) {
        AssertionUtil.assertArgumentNotNull("schema", schema);
        return SchemaUtil.newSchema(SchemaFactoryUtil.newW3cXmlSchemaFactory(), schema);
    }

    public static Schema newW3cXmlSchema(URL schema) {
        AssertionUtil.assertArgumentNotNull("schema", schema);
        return SchemaUtil.newSchema(SchemaFactoryUtil.newW3cXmlSchemaFactory(), schema);
    }

    public static Schema newRelaxNgSchema(File schema) {
        AssertionUtil.assertArgumentNotNull("schema", schema);
        return SchemaUtil.newSchema(SchemaFactoryUtil.newRelaxNgSchemaFactory(), schema);
    }

    public static Schema newRelaxNgSchema(Source schema) {
        AssertionUtil.assertArgumentNotNull("schema", schema);
        return SchemaUtil.newSchema(SchemaFactoryUtil.newRelaxNgSchemaFactory(), schema);
    }

    public static Schema newRelaxNgSchema(URL schema) {
        AssertionUtil.assertArgumentNotNull("schema", schema);
        return SchemaUtil.newSchema(SchemaFactoryUtil.newRelaxNgSchemaFactory(), schema);
    }

    public static Schema newSchema(SchemaFactory factory, File schema) {
        AssertionUtil.assertArgumentNotNull("factory", factory);
        AssertionUtil.assertArgumentNotNull("schema", schema);
        try {
            return factory.newSchema(schema);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }

    public static Schema newSchema(SchemaFactory factory, Source schema) {
        AssertionUtil.assertArgumentNotNull("factory", factory);
        AssertionUtil.assertArgumentNotNull("schema", schema);
        try {
            return factory.newSchema(schema);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }

    public static Schema newSchema(SchemaFactory factory, URL schema) {
        AssertionUtil.assertArgumentNotNull("factory", factory);
        AssertionUtil.assertArgumentNotNull("schema", schema);
        try {
            return factory.newSchema(schema);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }
}

