/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.xml;

import java.lang.reflect.Method;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codelibs.core.exception.ParserConfigurationRuntimeException;
import org.codelibs.core.exception.SAXRuntimeException;
import org.codelibs.core.lang.ClassUtil;
import org.codelibs.core.lang.MethodUtil;
import org.codelibs.core.misc.AssertionUtil;
import org.xml.sax.SAXException;

public abstract class SAXParserFactoryUtil {
    public static SAXParserFactory newInstance() {
        return SAXParserFactory.newInstance();
    }

    public static SAXParser newSAXParser() {
        return SAXParserFactoryUtil.newSAXParser(SAXParserFactoryUtil.newInstance());
    }

    public static SAXParser newSAXParser(SAXParserFactory factory) {
        AssertionUtil.assertArgumentNotNull("factory", factory);
        try {
            return factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigurationRuntimeException(e);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }

    public static boolean setXIncludeAware(SAXParserFactory spf, boolean state) {
        AssertionUtil.assertArgumentNotNull("spf", spf);
        try {
            Method method = ClassUtil.getMethod(spf.getClass(), "setXIncludeAware", Boolean.TYPE);
            MethodUtil.invoke(method, spf, state);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

