/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.misc.AssertionUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class DomUtil {
    public static InputStream getContentsAsStream(String contents) {
        AssertionUtil.assertArgumentNotNull("contents", contents);
        return DomUtil.getContentsAsStream(contents, null);
    }

    public static InputStream getContentsAsStream(String contents, String encoding) {
        AssertionUtil.assertArgumentNotNull("contents", contents);
        if (encoding == null) {
            return new ByteArrayInputStream(contents.getBytes());
        }
        try {
            return new ByteArrayInputStream(contents.getBytes(encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static String encodeAttrQuot(String s) {
        if (s == null) {
            return null;
        }
        char[] content = s.toCharArray();
        StringBuilder buf = new StringBuilder(s.length() + 100);
        block6: for (char element : content) {
            switch (element) {
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(element);
                }
            }
        }
        return buf.toString();
    }

    public static String encodeText(String s) {
        if (s == null) {
            return null;
        }
        char[] content = s.toCharArray();
        StringBuilder buf = new StringBuilder(s.length() + 100);
        block5: for (char ch : content) {
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return new String(buf);
    }

    public static String toString(Document document) {
        AssertionUtil.assertArgumentNotNull("document", document);
        StringBuilder buf = new StringBuilder(1000);
        DomUtil.appendElement(document.getDocumentElement(), buf);
        return new String(buf);
    }

    public static String toString(Element element) {
        AssertionUtil.assertArgumentNotNull("element", element);
        StringBuilder buf = new StringBuilder(1000);
        DomUtil.appendElement(element, buf);
        return new String(buf);
    }

    public static void appendElement(Element element, StringBuilder buf) {
        AssertionUtil.assertArgumentNotNull("element", element);
        AssertionUtil.assertArgumentNotNull("buf", buf);
        String tag = element.getTagName();
        buf.append('<');
        buf.append(tag);
        DomUtil.appendAttrs(element.getAttributes(), buf);
        buf.append('>');
        DomUtil.appendChildren(element.getChildNodes(), buf);
        buf.append("</");
        buf.append(tag);
        buf.append('>');
    }

    public static void appendChildren(NodeList children, StringBuilder buf) {
        AssertionUtil.assertArgumentNotNull("children", children);
        AssertionUtil.assertArgumentNotNull("buf", buf);
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            DomUtil.appendNode(children.item(i), buf);
        }
    }

    public static void appendAttrs(NamedNodeMap attrs, StringBuilder buf) {
        AssertionUtil.assertArgumentNotNull("attrs", attrs);
        AssertionUtil.assertArgumentNotNull("buf", buf);
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attrs.item(i);
            buf.append(' ');
            DomUtil.appendAttr(attr, buf);
        }
    }

    public static void appendAttr(Attr attr, StringBuilder buf) {
        AssertionUtil.assertArgumentNotNull("attr", attr);
        AssertionUtil.assertArgumentNotNull("buf", buf);
        buf.append(attr.getName());
        buf.append("=\"");
        buf.append(DomUtil.encodeAttrQuot(attr.getValue()));
        buf.append('\"');
    }

    public static void appendText(Text text, StringBuilder buf) {
        AssertionUtil.assertArgumentNotNull("text", text);
        AssertionUtil.assertArgumentNotNull("buf", buf);
        buf.append(DomUtil.encodeText(text.getData()));
    }

    public static void appendCDATASection(CDATASection cdataSection, StringBuilder buf) {
        AssertionUtil.assertArgumentNotNull("cdataSection", cdataSection);
        AssertionUtil.assertArgumentNotNull("buf", buf);
        buf.append("<![CDATA[");
        buf.append(cdataSection.getData());
        buf.append("]]>");
    }

    public static void appendEntityReference(EntityReference entityReference, StringBuilder buf) {
        AssertionUtil.assertArgumentNotNull("entityReference", entityReference);
        AssertionUtil.assertArgumentNotNull("buf", buf);
        buf.append('&');
        buf.append(entityReference.getNodeName());
        buf.append(';');
    }

    public static void appendNode(Node node, StringBuilder buf) {
        AssertionUtil.assertArgumentNotNull("node", node);
        AssertionUtil.assertArgumentNotNull("buf", buf);
        switch (node.getNodeType()) {
            case 1: {
                DomUtil.appendElement((Element)node, buf);
                break;
            }
            case 3: {
                DomUtil.appendText((Text)node, buf);
                break;
            }
            case 4: {
                DomUtil.appendCDATASection((CDATASection)node, buf);
                break;
            }
            case 5: {
                DomUtil.appendEntityReference((EntityReference)node, buf);
            }
        }
    }
}

