/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.timer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codelibs.core.collection.SLinkedList;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;

public class TimeoutManager
implements Runnable {
    protected static final TimeoutManager instance = new TimeoutManager();
    protected Thread thread;
    protected final SLinkedList<TimeoutTask> timeoutTaskList = new SLinkedList();

    private TimeoutManager() {
    }

    public static TimeoutManager getInstance() {
        return instance;
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "CoreLib-TimeoutManager");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(long timeoutMillis) throws InterruptedException {
        Thread thread = this.thread;
        TimeoutManager timeoutManager = this;
        synchronized (timeoutManager) {
            if (thread == null) {
                return true;
            }
            this.thread = null;
        }
        thread.interrupt();
        thread.join(timeoutMillis);
        return !thread.isAlive();
    }

    public synchronized void clear() {
        this.timeoutTaskList.clear();
    }

    public synchronized TimeoutTask addTimeoutTarget(TimeoutTarget timeoutTarget, int timeout, boolean permanent) {
        TimeoutTask task = new TimeoutTask(timeoutTarget, timeout, permanent);
        this.timeoutTaskList.addLast(task);
        if (this.timeoutTaskList.size() == 1) {
            this.start();
        }
        return task;
    }

    public synchronized int getTimeoutTaskCount() {
        return this.timeoutTaskList.size();
    }

    @Override
    public void run() {
        boolean interrupted = false;
        while (true) {
            List<TimeoutTask> expiredTask = this.getExpiredTask();
            Iterator<TimeoutTask> iterator = expiredTask.iterator();
            while (iterator.hasNext()) {
                TimeoutTask timeoutTask;
                TimeoutTask task = timeoutTask = iterator.next();
                task.expired();
                if (!task.isPermanent()) continue;
                task.restart();
            }
            if (interrupted || this.thread.isInterrupted() || this.stopIfLeisure()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
    }

    protected synchronized List<TimeoutTask> getExpiredTask() {
        ArrayList<TimeoutTask> expiredTask = new ArrayList<TimeoutTask>();
        try {
            if (this.timeoutTaskList == null || this.timeoutTaskList.isEmpty()) {
                return expiredTask;
            }
        }
        catch (Exception e) {
            return expiredTask;
        }
        for (SLinkedList.Entry e = this.timeoutTaskList.getFirstEntry(); e != null; e = e.getNext()) {
            TimeoutTask task = (TimeoutTask)e.getElement();
            if (task.isCanceled()) {
                e.remove();
                continue;
            }
            if (task.isStopped() || !task.isExpired()) continue;
            expiredTask.add(task);
            if (task.isPermanent()) continue;
            e.remove();
        }
        return expiredTask;
    }

    protected synchronized boolean stopIfLeisure() {
        try {
            if (this.timeoutTaskList == null || this.timeoutTaskList.isEmpty()) {
                this.thread = null;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }
}

